/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class DiggerHelmetConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.IntValue DRINK_MB;
    public static final ForgeConfigSpec.IntValue DEFAULT_COOLDOWN;
    public static final ForgeConfigSpec.DoubleValue PICKAXE_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue SHOVEL_MULTIPLIER;
    public static final ForgeConfigSpec.BooleanValue ENABLE_ZOMBIE_CANDLE;
    public static final ForgeConfigSpec.DoubleValue ZOMBIE_CANDLE_CHANCE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_CANDLE_SLIME;
    public static final ForgeConfigSpec.DoubleValue CANDLE_SLIME_SPAWN_CHANCE;
    public static final ForgeConfigSpec.IntValue CANDLE_SLIME_MIN_Y;
    public static final ForgeConfigSpec.IntValue CANDLE_SLIME_MAX_Y;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "diggerhelmet-common.toml");
    }

    static {
        BUILDER.push("AutoDrinker Settings");
        DRINK_MB = BUILDER.comment("The amount of fluid in millibuckets consumed per use").defineInRange("drink_mb", 25, 1, 1000);
        DEFAULT_COOLDOWN = BUILDER.comment("Default cooldown time in ticks (20 ticks = 1 second)").defineInRange("default_cooldown", 100, 1, 1000);
        BUILDER.pop();
        BUILDER.push("MiningSpeedModifier Settings");
        PICKAXE_MULTIPLIER = BUILDER.comment("Multiplier for pickaxe mining speed").defineInRange("pickaxe_multiplier", 2.5, 1.0, 10.0);
        SHOVEL_MULTIPLIER = BUILDER.comment("Multiplier for shovel mining speed").defineInRange("shovel_multiplier", 1.8, 1.0, 10.0);
        BUILDER.pop();
        BUILDER.push("Zombie Candle Settings");
        ENABLE_ZOMBIE_CANDLE = BUILDER.comment("Enable/disable spawning of zombies with a candle").define("enable_zombie_candle", false);
        ZOMBIE_CANDLE_CHANCE = BUILDER.comment("Chance of a zombie spawning with a candle (0.0 - 1.0)").defineInRange("zombie_candle_chance", 0.2, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("Candle Slime Settings");
        ENABLE_CANDLE_SLIME = BUILDER.comment("Enable/disable spawning of slimes with a candle").define("enable_candle_slime", false);
        CANDLE_SLIME_SPAWN_CHANCE = BUILDER.comment("Chance of a slime spawning with a candle (0.0 - 1.0)").defineInRange("candle_slime_spawn_chance", 0.5, 0.0, 1.0);
        CANDLE_SLIME_MIN_Y = BUILDER.comment("Minimum Y level for candle slime spawn").defineInRange("candle_slime_min_y", 50, 0, 256);
        CANDLE_SLIME_MAX_Y = BUILDER.comment("Maximum Y level for candle slime spawn").defineInRange("candle_slime_max_y", 70, 0, 256);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

