/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.event;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.client.DynamicLightingManager;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="diggerhelmet", value={Dist.CLIENT})
public class ClientForgeEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (!(event.getItemStack().m_41720_() instanceof DiggerHelmetItem)) {
            return;
        }
        List tooltip = event.getToolTip();
        boolean foundFirstWhenOnHead = false;
        Iterator iterator = tooltip.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            String text = component.getString();
            if (!text.equals("When on Head:")) continue;
            if (foundFirstWhenOnHead) {
                Component next;
                String nextText;
                iterator.remove();
                while (!(!iterator.hasNext() || (nextText = (next = (Component)iterator.next()).getString()).isEmpty() || nextText.contains("When in") || nextText.contains("Durability") || nextText.contains("Enchantments") || !nextText.startsWith(" ") && !nextText.startsWith("+") || !nextText.startsWith(" ") && !nextText.startsWith("+"))) {
                    iterator.remove();
                }
                continue;
            }
            foundFirstWhenOnHead = true;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (!DiggerHelmet.isSDLLoaded() && player != null && mc.f_91073_ != null) {
                DynamicLightingManager.onClientTick(event);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Player && !DiggerHelmet.isSDLLoaded()) {
            DynamicLightingManager.clearAllLights();
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaveWorld(EntityLeaveLevelEvent event) {
        if (event.getEntity() instanceof Player && !DiggerHelmet.isSDLLoaded()) {
            DynamicLightingManager.clearAllLights();
        }
    }
}

