/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import java.lang.reflect.Proxy;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DiggerHelmetThermalMaterial
implements ArmorMaterial {
    public static final DiggerHelmetThermalMaterial INSTANCE = new DiggerHelmetThermalMaterial();
    private static final int[] BASE_DURABILITY = new int[]{13, 15, 16, 11};
    private static final int MAX_DAMAGE_FACTOR = 6;
    private static final int[] PROTECTION_AMOUNTS = new int[]{2, 0, 0, 0};
    private volatile Object temperatureAlteringProxy = null;
    private volatile boolean proxyInitialized = false;

    private DiggerHelmetThermalMaterial() {
    }

    private Object createTemperatureAlteringProxy() {
        if (!DiggerHelmet.isTFCAmbientalLoaded()) {
            return null;
        }
        try {
            Class<?> tempAlteringInterface = Class.forName("com.lumintorious.tfcambiental.item.material.TemperatureAlteringMaterial");
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            if (tempAlteringInterface == null || tempModifierClass == null) {
                DiggerHelmet.LOGGER.warn("TFC Ambiental classes not found, cannot create proxy");
                return null;
            }
            Object proxy = Proxy.newProxyInstance(tempAlteringInterface.getClassLoader(), new Class[]{ArmorMaterial.class, tempAlteringInterface}, (proxyObj, method, args) -> {
                block13: {
                    if (!"getTempModifier".equals(method.getName()) || args == null || args.length != 1 || !(args[0] instanceof ItemStack)) break block13;
                    return this.getTempModifier((ItemStack)args[0]);
                    {
                        catch (Exception e) {
                            DiggerHelmet.LOGGER.warn("Error in proxy method: " + method.getName(), (Throwable)e);
                            return null;
                        }
                    }
                }
                try {
                    return method.invoke((Object)this, args);
                }
                catch (Exception e) {
                    if ("getDurabilityForType".equals(method.getName()) && args != null && args.length == 1) {
                        return this.m_266425_((ArmorItem.Type)args[0]);
                    }
                    if ("getDefenseForType".equals(method.getName()) && args != null && args.length == 1) {
                        return this.m_7366_((ArmorItem.Type)args[0]);
                    }
                    if ("getEnchantmentValue".equals(method.getName())) {
                        return this.m_6646_();
                    }
                    if ("getEquipSound".equals(method.getName())) {
                        return this.m_7344_();
                    }
                    if ("getRepairIngredient".equals(method.getName())) {
                        return this.m_6230_();
                    }
                    if ("getName".equals(method.getName())) {
                        return this.m_6082_();
                    }
                    if ("getToughness".equals(method.getName())) {
                        return Float.valueOf(this.m_6651_());
                    }
                    if ("getKnockbackResistance".equals(method.getName())) {
                        return Float.valueOf(this.m_6649_());
                    }
                    return null;
                }
            });
            DiggerHelmet.LOGGER.info("TemperatureAlteringMaterial proxy created successfully");
            return proxy;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Could not create TemperatureAlteringMaterial proxy", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTemperatureAlteringProxy() {
        if (!this.proxyInitialized) {
            DiggerHelmetThermalMaterial diggerHelmetThermalMaterial = this;
            synchronized (diggerHelmetThermalMaterial) {
                if (!this.proxyInitialized) {
                    this.temperatureAlteringProxy = this.createTemperatureAlteringProxy();
                    this.proxyInitialized = true;
                }
            }
        }
        return this.temperatureAlteringProxy;
    }

    public boolean hasTemperatureSupport() {
        return this.getTemperatureAlteringProxy() != null;
    }

    public int m_266425_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type pType) {
        return BASE_DURABILITY[pType.ordinal()] * 6;
    }

    public int m_7366_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ArmorItem.Type pType) {
        return PROTECTION_AMOUNTS[pType.ordinal()];
    }

    public int m_6646_() {
        return 10;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return SoundEvents.f_11677_;
    }

    @NotNull
    public Ingredient m_6230_() {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42416_)});
    }

    @NotNull
    public String m_6082_() {
        return "digger_helmet_thermal";
    }

    public float m_6651_() {
        return 0.0f;
    }

    public float m_6649_() {
        return 0.0f;
    }

    public Object getTempModifier(ItemStack stack) {
        if (!DiggerHelmet.isTFCAmbientalLoaded()) {
            return this.createEmptyTempModifier();
        }
        try {
            String liningType = DiggerHelmetItem.getLiningType(stack);
            if (liningType == null) {
                return this.createEmptyTempModifier();
            }
            if ("wool".equals(liningType)) {
                return this.createWoolTempModifier(stack);
            }
            if ("silk".equals(liningType)) {
                return this.createSilkTempModifier(stack);
            }
            return this.createEmptyTempModifier();
        }
        catch (Exception e) {
            return this.createEmptyTempModifier();
        }
    }

    private Object createWoolTempModifier(ItemStack stack) {
        try {
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            Object modifier = tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), Float.valueOf(1.5f), Float.valueOf(0.8f));
            return modifier;
        }
        catch (Exception e) {
            return this.createEmptyTempModifier();
        }
    }

    private Object createSilkTempModifier(ItemStack stack) {
        try {
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            Object modifier = tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString(), Float.valueOf(-1.5f), Float.valueOf(0.6f));
            return modifier;
        }
        catch (Exception e) {
            return this.createEmptyTempModifier();
        }
    }

    private Object createEmptyTempModifier() {
        try {
            Class<?> tempModifierClass = Class.forName("com.lumintorious.tfcambiental.modifier.TempModifier");
            return tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance("diggerhelmet:empty", Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Could not create empty temperature modifier", (Throwable)e);
            return null;
        }
    }

    public static boolean isTemperatureSupported() {
        return DiggerHelmet.isTFCAmbientalLoaded();
    }
}

