/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.mixin;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.client.DynamicLightingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockLightEngine.class})
public abstract class BlockLightEngineMixin {
    @Inject(method={"getEmission"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetEmission(long longPos, BlockState state, CallbackInfoReturnable<Integer> cir) {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            return;
        }
        if (DiggerHelmet.isSDLLoaded() || (Integer)cir.getReturnValue() >= 15) {
            return;
        }
        BlockPos pos = BlockPos.m_122022_((long)longPos);
        int dynamicLight = DynamicLightingManager.getLightLevel(pos);
        if (dynamicLight > 0) {
            cir.setReturnValue((Object)Math.max((Integer)cir.getReturnValue(), dynamicLight));
        }
    }
}

