/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet;

import com.mojang.logging.LogUtils;
import dev.thomas.diggerhelmet.client.ClientSetup;
import dev.thomas.diggerhelmet.common.init.registries.ModBlocks;
import dev.thomas.diggerhelmet.common.init.registries.ModCreativeTabs;
import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.init.registries.ModMenu;
import dev.thomas.diggerhelmet.common.init.registries.ModRecipeSerializers;
import dev.thomas.diggerhelmet.config.DiggerHelmetConfig;
import dev.thomas.diggerhelmet.entity.ModEntities;
import dev.thomas.diggerhelmet.integration.CuriosIntegration;
import dev.thomas.diggerhelmet.integration.TFCAmbientalIntegration;
import dev.thomas.diggerhelmet.loot.ModLootModifires;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;

@Mod(value="diggerhelmet")
public class DiggerHelmet {
    public static final String MOD_ID = "diggerhelmet";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final String SDL_MODID = "sodiumdynamiclights";
    private static final String CURIOS_MODID = "curios";
    private static final String TFC_AMBIENTAL_MODID = "tfcambiental";

    public DiggerHelmet() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        DiggerHelmetConfig.register();
        ModItems.register(modEventBus);
        ModCreativeTabs.register(modEventBus);
        ModEntities.register(modEventBus);
        ModLootModifires.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModMenu.CONTAINERS.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        if (DiggerHelmet.isCuriosLoaded()) {
            CuriosIntegration.setup();
        }
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(this::onClientSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("DiggerHelmet common setup starting...");
        event.enqueueWork(() -> {
            if (DiggerHelmet.isTFCAmbientalLoaded()) {
                try {
                    TFCAmbientalIntegration.initialize();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to initialize TFC Ambiental integration - this is not critical, mod will continue without temperature features", (Throwable)e);
                }
            }
            DiggerHelmet.initializeIntegrations();
        });
        LOGGER.info("DiggerHelmet common setup completed");
    }

    private static void initializeIntegrations() {
        if (DiggerHelmet.isCuriosLoaded()) {
            try {
                LOGGER.info("Curios integration available");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to initialize Curios integration", (Throwable)e);
            }
        }
        if (DiggerHelmet.isSDLLoaded()) {
            try {
                LOGGER.info("Sodium Dynamic Lights integration available");
            }
            catch (Exception e) {
                LOGGER.warn("Failed to initialize SDL integration", (Throwable)e);
            }
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            ClientSetup.init();
        }
    }

    public static boolean isSDLLoaded() {
        return ModList.get().isLoaded(SDL_MODID);
    }

    public static boolean isCuriosLoaded() {
        return ModList.get().isLoaded(CURIOS_MODID);
    }

    public static boolean isTFCAmbientalLoaded() {
        return ModList.get().isLoaded(TFC_AMBIENTAL_MODID);
    }
}

