/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.client;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import dev.thomas.diggerhelmet.integration.CuriosLightingIntegration;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class SDLLightsAdapter {
    private static final int PLAYER_HELMET_LIGHT = 14;
    private static final int PLAYER_HAND_LIGHT = 10;
    private static final int MOB_LIGHT = 12;
    private static final int ARMOR_STAND_LIGHT = 10;
    private static final List<EntityType<? extends LivingEntity>> SUPPORTED_MOBS = Arrays.asList(EntityType.f_20501_, EntityType.f_20458_);
    private static boolean initialized = false;

    public static void init() {
        if (!DiggerHelmet.isSDLLoaded() || initialized) {
            return;
        }
        try {
            SDLLightsAdapter.enableSDLSettings();
            SDLLightsAdapter.registerHandlers();
            initialized = true;
            DiggerHelmet.LOGGER.info("Enhanced SDL integration initialized successfully");
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.error("Failed to initialize enhanced SDL integration", (Throwable)e);
        }
    }

    private static void enableSDLSettings() {
        try {
            Class<?> sdlClass = Class.forName("toni.sodiumdynamiclights.SodiumDynamicLights");
            Object sdlInstance = sdlClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            Object config = sdlClass.getField("config").get(sdlInstance);
            Class<?> configClass = Class.forName("toni.sodiumdynamiclights.DynamicLightsConfig");
            Object entitiesLightSource = configClass.getMethod("getEntitiesLightSource", new Class[0]).invoke(config, new Object[0]);
            Boolean entitiesEnabled = (Boolean)entitiesLightSource.getClass().getMethod("get", new Class[0]).invoke(entitiesLightSource, new Object[0]);
            Object selfLightSource = configClass.getMethod("getSelfLightSource", new Class[0]).invoke(config, new Object[0]);
            Boolean selfEnabled = (Boolean)selfLightSource.getClass().getMethod("get", new Class[0]).invoke(selfLightSource, new Object[0]);
            boolean needsSave = false;
            if (!entitiesEnabled.booleanValue()) {
                entitiesLightSource.getClass().getMethod("set", Object.class).invoke(entitiesLightSource, true);
                needsSave = true;
                DiggerHelmet.LOGGER.info("Auto-enabled Dynamic Entity Lighting for DiggerHelmet");
            }
            if (!selfEnabled.booleanValue()) {
                selfLightSource.getClass().getMethod("set", Object.class).invoke(selfLightSource, true);
                needsSave = true;
                DiggerHelmet.LOGGER.info("Auto-enabled Self Light Source for DiggerHelmet");
            }
            if (needsSave) {
                Object specs = configClass.getField("SPECS").get(null);
                specs.getClass().getMethod("save", new Class[0]).invoke(specs, new Object[0]);
                DiggerHelmet.LOGGER.info("SDL configuration saved");
            }
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Could not automatically configure SDL settings", (Throwable)e);
        }
    }

    private static void registerHandlers() {
        try {
            Class<?> handlersClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandlers");
            Class<?> handlerClass = Class.forName("dev.lambdaurora.lambdynlights.api.DynamicLightHandler");
            SDLLightsAdapter.registerPlayerHandler(handlersClass, handlerClass);
            SDLLightsAdapter.registerMobHandlers(handlersClass, handlerClass);
            SDLLightsAdapter.registerArmorStandHandler(handlersClass, handlerClass);
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.error("Failed to register SDL handlers", (Throwable)e);
        }
    }

    private static void registerPlayerHandler(Class<?> handlersClass, Class<?> handlerClass) {
        try {
            Object handler = Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
                Player player = (Player)args[0];
                switch (method.getName()) {
                    case "getLuminance": {
                        return SDLLightsAdapter.getDiggerHelmetLuminance((Entity)player);
                    }
                    case "isWaterSensitive": {
                        return true;
                    }
                }
                return null;
            });
            handlersClass.getMethod("registerDynamicLightHandler", EntityType.class, handlerClass).invoke(null, EntityType.f_20532_, handler);
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.error("Failed to register player light handler", (Throwable)e);
        }
    }

    private static void registerMobHandlers(Class<?> handlersClass, Class<?> handlerClass) {
        for (EntityType<? extends LivingEntity> mobType : SUPPORTED_MOBS) {
            try {
                Object handler = Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
                    LivingEntity entity = (LivingEntity)args[0];
                    switch (method.getName()) {
                        case "getLuminance": {
                            return SDLLightsAdapter.getDiggerHelmetLuminance((Entity)entity);
                        }
                        case "isWaterSensitive": {
                            return true;
                        }
                    }
                    return null;
                });
                handlersClass.getMethod("registerDynamicLightHandler", EntityType.class, handlerClass).invoke(null, mobType, handler);
            }
            catch (Exception e) {
                DiggerHelmet.LOGGER.error("Failed to register mob light handler for " + String.valueOf(mobType), (Throwable)e);
            }
        }
    }

    private static void registerArmorStandHandler(Class<?> handlersClass, Class<?> handlerClass) {
        try {
            Object handler = Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
                ArmorStand armorStand = (ArmorStand)args[0];
                switch (method.getName()) {
                    case "getLuminance": {
                        return SDLLightsAdapter.getDiggerHelmetLuminance((Entity)armorStand);
                    }
                    case "isWaterSensitive": {
                        return true;
                    }
                }
                return null;
            });
            handlersClass.getMethod("registerDynamicLightHandler", EntityType.class, handlerClass).invoke(null, EntityType.f_20529_, handler);
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.error("Failed to register armor stand light handler", (Throwable)e);
        }
    }

    private static int getDiggerHelmetLuminance(Entity entity) {
        ArmorStand armorStand;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (SDLLightsAdapter.isWearingDiggerHelmet((Entity)player)) {
                return 14;
            }
            if (SDLLightsAdapter.isHoldingDiggerHelmet(player)) {
                return 10;
            }
        } else if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (SDLLightsAdapter.isWearingDiggerHelmet((Entity)living)) {
                return 12;
            }
        } else if (entity instanceof ArmorStand && SDLLightsAdapter.isWearingDiggerHelmet((Entity)(armorStand = (ArmorStand)entity))) {
            return 10;
        }
        return 0;
    }

    private static boolean isWearingDiggerHelmet(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack helmet = living.m_6844_(EquipmentSlot.HEAD);
            if (helmet.m_41720_() instanceof DiggerHelmetItem) {
                return true;
            }
            return DiggerHelmet.isCuriosLoaded() && CuriosLightingIntegration.isWearingDiggerHelmet((Entity)living);
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            ItemStack helmet = armorStand.m_6844_(EquipmentSlot.HEAD);
            return helmet.m_41720_() instanceof DiggerHelmetItem;
        }
        return false;
    }

    private static boolean isHoldingDiggerHelmet(Player player) {
        return player.m_21205_().m_41720_() instanceof DiggerHelmetItem || player.m_21206_().m_41720_() instanceof DiggerHelmetItem;
    }

    public static boolean isInitialized() {
        return initialized;
    }
}

