/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.init.registries;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.item.AutoDrinkerItem;
import dev.thomas.diggerhelmet.common.item.BrokenDiggerHelmetItem;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import dev.thomas.diggerhelmet.common.item.EternalCandleItem;
import dev.thomas.diggerhelmet.common.item.MiningSpeedModifier;
import dev.thomas.diggerhelmet.common.item.SilkLiningItem;
import dev.thomas.diggerhelmet.common.item.WoolLiningItem;
import dev.thomas.diggerhelmet.entity.ModEntities;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"diggerhelmet");
    public static final RegistryObject<DiggerHelmetItem> DIGGER_HELMET = ITEMS.register("digger_helmet", DiggerHelmetItem::new);
    public static final RegistryObject<BrokenDiggerHelmetItem> BROKEN_DIGGER_HELMET = ITEMS.register("broken_digger_helmet", BrokenDiggerHelmetItem::new);
    public static final RegistryObject<Item> CANDLESLIME_SPAWN_EGG = ITEMS.register("candleslime_spawn_egg", () -> new ForgeSpawnEggItem(ModEntities.CandleSlime, 13991478, 0x1D0D00, new Item.Properties()));
    public static final RegistryObject<EternalCandleItem> ETERNAL_CANDLE = ITEMS.register("eternal_candle", () -> new EternalCandleItem(new Item.Properties()));
    public static final RegistryObject<Item> WOOL_LINING = ITEMS.register("wool_lining", () -> new WoolLiningItem(new Item.Properties()));
    public static final RegistryObject<Item> SILK_LINING = ITEMS.register("silk_lining", () -> new SilkLiningItem(new Item.Properties()));
    public static final RegistryObject<AutoDrinkerItem> AUTO_DRINKER = ITEMS.register("auto_drink_modifier", () -> new AutoDrinkerItem(new Item.Properties()));
    public static final RegistryObject<MiningSpeedModifier> MINING_SPEED_MODIFIER = ITEMS.register("mining_speed_modifier", () -> new MiningSpeedModifier(new Item.Properties().m_41487_(1)));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
        ModItems.registerDebugCommands();
    }

    public static boolean areLiningsAvailable() {
        return DiggerHelmet.isTFCAmbientalLoaded();
    }

    public static Item getWoolLining() {
        return ModItems.areLiningsAvailable() ? (Item)WOOL_LINING.get() : null;
    }

    public static Item getSilkLining() {
        return ModItems.areLiningsAvailable() ? (Item)SILK_LINING.get() : null;
    }

    private static void registerDebugCommands() {
        if (DiggerHelmet.LOGGER.isDebugEnabled()) {
            // empty if block
        }
    }
}

