/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.item;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.client.BrokenDiggerHelmetRenderer;
import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.item.BrokenDiggerHelmetArmor;
import dev.thomas.diggerhelmet.integration.CuriosIntegration;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BrokenDiggerHelmetItem
extends ArmorItem
implements GeoItem,
ICurioItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BrokenDiggerHelmetItem() {
        super((ArmorMaterial)BrokenDiggerHelmetArmor.BROKEN_DIGGER_HELMET, ArmorItem.Type.HELMET, new Item.Properties().m_41487_(1).m_41503_(1));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static BrokenDiggerHelmetRenderer renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                if (renderer == null) {
                    renderer = new BrokenDiggerHelmetRenderer();
                }
                renderer.prepForRender((Entity)entity, stack, slot, original);
                return renderer;
            }
        });
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"item.diggerhelmet.broken_helmet.tooltip").m_130940_(ChatFormatting.RED));
        components.add((Component)Component.m_237115_((String)"item.diggerhelmet.broken_helmet.repair_info").m_130940_(ChatFormatting.GRAY));
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return 1;
    }

    public int getDamage(@NotNull ItemStack stack) {
        return 1;
    }

    public void setDamage(@NotNull ItemStack stack, int damage) {
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "diggerhelmet:textures/models/armor/digger_helmet_broken.png";
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack, @NotNull Enchantment enchantment) {
        return false;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return 0xFF0000;
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41720_() instanceof BrokenDiggerHelmetItem;
    }

    public static ItemStack createBrokenHelmet(ItemStack originalHelmet) {
        ItemStack brokenHelmet = new ItemStack((ItemLike)ModItems.BROKEN_DIGGER_HELMET.get());
        if (originalHelmet.m_41782_()) {
            brokenHelmet.m_41751_(originalHelmet.m_41783_().m_6426_());
        }
        return brokenHelmet;
    }

    public static ItemStack repairHelmet(ItemStack brokenHelmet, int newDurability) {
        ItemStack repairedHelmet = new ItemStack((ItemLike)ModItems.DIGGER_HELMET.get());
        if (brokenHelmet.m_41782_()) {
            repairedHelmet.m_41751_(brokenHelmet.m_41783_().m_6426_());
        }
        repairedHelmet.m_41721_(repairedHelmet.m_41776_() - newDurability);
        return repairedHelmet;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return slotContext.identifier().equals("head");
    }

    public boolean canUnequip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return DiggerHelmet.isCuriosLoaded() ? CuriosIntegration.createCurioProvider(stack) : super.initCapabilities(stack, nbt);
    }
}

