/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.item;

import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.init.registries.ModMenu;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DiggerHelmetContainer
extends AbstractContainerMenu {
    private final Container container;
    private final ItemStack helmetStack;
    private final Item miningSpeedItem;
    private final Item autoDrinkerItem;

    public DiggerHelmetContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(windowId, playerInventory, extraData.m_130267_());
    }

    public DiggerHelmetContainer(int windowId, Inventory playerInventory, ItemStack helmetStack) {
        super((MenuType)ModMenu.SINGLE_SLOT_CONTAINER.get(), windowId);
        this.helmetStack = helmetStack;
        this.miningSpeedItem = (Item)ModItems.MINING_SPEED_MODIFIER.get();
        this.autoDrinkerItem = (Item)ModItems.AUTO_DRINKER.get();
        this.container = new SimpleContainer(3){

            public void m_6836_(int slot, @NotNull ItemStack stack) {
                super.m_6836_(slot, stack);
                DiggerHelmetContainer.this.saveToNBT();
            }
        };
        CompoundTag helmetNBT = helmetStack.m_41784_();
        if (helmetNBT.m_128441_("HelmetInventory")) {
            CompoundTag inventoryTag = helmetNBT.m_128469_("HelmetInventory");
            this.loadFromNBT(inventoryTag);
        }
        this.m_38897_(new Slot(this.container, 0, 62, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41720_() == DiggerHelmetContainer.this.autoDrinkerItem;
            }

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                DiggerHelmetContainer.this.saveToNBT();
            }
        });
        this.m_38897_(new Slot(this.container, 1, 80, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                return stack.m_41720_() == DiggerHelmetContainer.this.miningSpeedItem;
            }

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                DiggerHelmetContainer.this.saveToNBT();
            }
        });
        this.m_38897_(new Slot(this.container, 2, 98, 35){

            public boolean m_5857_(@NotNull ItemStack stack) {
                if (!ModItems.areLiningsAvailable()) {
                    return false;
                }
                return stack.m_41720_() == ModItems.WOOL_LINING.get() || stack.m_41720_() == ModItems.SILK_LINING.get();
            }

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                DiggerHelmetContainer.this.saveToNBT();
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    private void saveToNBT() {
        CompoundTag helmetTag;
        CompoundTag inventoryTag = new CompoundTag();
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemTag);
            itemsList.add((Object)itemTag);
        }
        inventoryTag.m_128365_("Items", (Tag)itemsList);
        this.helmetStack.m_41784_().m_128365_("HelmetInventory", (Tag)inventoryTag);
        if (!this.helmetStack.m_41782_() || (helmetTag = this.helmetStack.m_41783_()) != null) {
            // empty if block
        }
    }

    private void loadFromNBT(CompoundTag nbt) {
        ListTag itemsList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag itemTag = itemsList.m_128728_(i);
            byte slot = itemTag.m_128445_("Slot");
            if (slot < 0 || slot >= this.container.m_6643_()) continue;
            this.container.m_6836_((int)slot, ItemStack.m_41712_((CompoundTag)itemTag));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        boolean hasInInventory = player.m_150109_().m_36063_(this.helmetStack);
        boolean hasOnHead = player.m_6844_(EquipmentSlot.HEAD) == this.helmetStack || player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof DiggerHelmetItem && ItemStack.m_150942_((ItemStack)player.m_6844_(EquipmentSlot.HEAD), (ItemStack)this.helmetStack);
        return hasInInventory || hasOnHead;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack resultStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack sourceStack = slot.m_7993_();
            resultStack = sourceStack.m_41777_();
            if (index < 3) {
                if (!this.m_38903_(sourceStack, 3, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                boolean moved = false;
                if (sourceStack.m_41720_() == this.miningSpeedItem) {
                    moved = this.m_38903_(sourceStack, 1, 2, false);
                } else if (sourceStack.m_41720_() == this.autoDrinkerItem) {
                    moved = this.m_38903_(sourceStack, 0, 1, false);
                } else if (ModItems.areLiningsAvailable() && (sourceStack.m_41720_() == ModItems.WOOL_LINING.get() || sourceStack.m_41720_() == ModItems.SILK_LINING.get())) {
                    moved = this.m_38903_(sourceStack, 2, 3, false);
                }
                if (!moved) {
                    return ItemStack.f_41583_;
                }
            }
            if (sourceStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return resultStack;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.saveToNBT();
    }

    public Container getContainer() {
        return this.container;
    }
}

