/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.item;

import dev.thomas.diggerhelmet.common.init.registries.ModBlocks;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EternalCandleItem
extends Item {
    public EternalCandleItem(Item.Properties properties) {
        super(properties.m_41487_(16));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.eternal_candle.main").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}));
        if (level != null && level.m_5776_() && Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.eternal_candle.shift_info").m_130940_(ChatFormatting.GRAY));
            components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.eternal_candle.more_info").m_130940_(ChatFormatting.BLUE));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.diggerhelmet.digger_helmet.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState state = level.m_8055_(pos);
        if (face == Direction.UP && state.m_60783_((BlockGetter)level, pos, Direction.UP)) {
            level.m_46597_(pos.m_7494_(), ((Block)ModBlocks.ETERNAL_CANDLE.get()).m_49966_());
            this.playPlaceSound(level, pos.m_7494_());
            this.consumeItem(context);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private void playPlaceSound(Level level, BlockPos pos) {
        level.m_5594_(null, pos, SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
    }

    private void consumeItem(UseOnContext context) {
        if (!Objects.requireNonNull(context.m_43723_()).m_150110_().f_35937_) {
            context.m_43722_().m_41774_(1);
        }
    }
}

