/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.common.recipe;

import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.init.registries.ModRecipeSerializers;
import dev.thomas.diggerhelmet.common.item.BrokenDiggerHelmetItem;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class HelmetRepairRecipe
extends CustomRecipe {
    public HelmetRepairRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@Nonnull CraftingContainer container, @Nonnull Level level) {
        ItemStack helmet = ItemStack.f_41583_;
        ItemStack leather = ItemStack.f_41583_;
        ItemStack candle = ItemStack.f_41583_;
        ItemStack scissors = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == ModItems.DIGGER_HELMET.get() && stack.m_41768_()) {
                if (!helmet.m_41619_()) {
                    return false;
                }
                helmet = stack;
                continue;
            }
            if (stack.m_41720_() == ModItems.BROKEN_DIGGER_HELMET.get()) {
                if (!helmet.m_41619_()) {
                    return false;
                }
                helmet = stack;
                continue;
            }
            if (stack.m_41720_() == Items.f_42454_) {
                if (!leather.m_41619_()) {
                    return false;
                }
                leather = stack;
                continue;
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"candles")))) {
                if (!candle.m_41619_()) {
                    return false;
                }
                candle = stack;
                continue;
            }
            if (stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"shears")))) {
                if (!scissors.m_41619_()) {
                    return false;
                }
                scissors = stack;
                continue;
            }
            return false;
        }
        return !helmet.m_41619_() && !leather.m_41619_() && !candle.m_41619_() && !scissors.m_41619_();
    }

    public ItemStack assemble(@Nonnull CraftingContainer container, @Nonnull RegistryAccess registryAccess) {
        ItemStack helmet = ItemStack.f_41583_;
        ItemStack scissors = ItemStack.f_41583_;
        boolean isBrokenHelmet = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == ModItems.DIGGER_HELMET.get()) {
                helmet = stack;
                continue;
            }
            if (stack.m_41720_() == ModItems.BROKEN_DIGGER_HELMET.get()) {
                helmet = stack;
                isBrokenHelmet = true;
                continue;
            }
            if (!stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"shears")))) continue;
            scissors = stack;
        }
        if (helmet.m_41619_() || scissors.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (isBrokenHelmet) {
            return BrokenDiggerHelmetItem.repairHelmet(helmet, 100);
        }
        ItemStack result = helmet.m_41777_();
        int maxDurability = result.m_41776_();
        int repairAmount = (int)((float)maxDurability * 0.6f);
        int newDamage = Math.max(0, result.m_41773_() - repairAmount);
        result.m_41721_(newDamage);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.HELMET_REPAIR_RECIPE.get();
    }

    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer container) {
        ItemStack stack;
        int i;
        NonNullList remaining = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        boolean isBrokenHelmet = false;
        for (i = 0; i < container.m_6643_(); ++i) {
            stack = container.m_8020_(i);
            if (stack.m_41720_() != ModItems.BROKEN_DIGGER_HELMET.get()) continue;
            isBrokenHelmet = true;
            break;
        }
        for (i = 0; i < container.m_6643_(); ++i) {
            stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"shears")))) {
                ItemStack damagedScissors = stack.m_41777_();
                int scissorsMaxDurability = damagedScissors.m_41776_();
                int scissorsDamage = (int)((float)scissorsMaxDurability * (isBrokenHelmet ? 0.02f : 0.01f));
                int newScissorsDamage = Math.min(scissorsMaxDurability, damagedScissors.m_41773_() + scissorsDamage);
                damagedScissors.m_41721_(newScissorsDamage);
                remaining.set(i, (Object)damagedScissors);
                continue;
            }
            if (stack.m_41720_() != Items.f_42454_ && !stack.m_204117_(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"candles")))) continue;
            remaining.set(i, (Object)ItemStack.f_41583_);
        }
        return remaining;
    }
}

