/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.event;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.item.BrokenDiggerHelmetItem;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="diggerhelmet")
public class HelmetBreakHandler {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack helmetStack = player.m_6844_(EquipmentSlot.HEAD);
        if (helmetStack.m_41720_() instanceof DiggerHelmetItem && helmetStack.m_41773_() >= helmetStack.m_41776_() - 1) {
            HelmetBreakHandler.handleHelmetBreak(player, helmetStack, EquipmentSlot.HEAD);
        }
        if (DiggerHelmet.isCuriosLoaded()) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.findFirstCurio((Item)ModItems.DIGGER_HELMET.get()).ifPresent(curio -> {
                ItemStack curioStack = curio.stack();
                if (curioStack.m_41720_() instanceof DiggerHelmetItem && curioStack.m_41773_() >= curioStack.m_41776_() - 1) {
                    HelmetBreakHandler.handleCuriosHelmetBreak(player, curioStack);
                }
            }));
        }
    }

    private static void handleHelmetBreak(Player player, ItemStack helmetStack, EquipmentSlot slot) {
        if (DiggerHelmetItem.shouldBreakToBroken(helmetStack)) {
            ItemStack brokenHelmet = BrokenDiggerHelmetItem.createBrokenHelmet(helmetStack);
            player.m_8061_(slot, brokenHelmet);
            player.m_5661_((Component)Component.m_237115_((String)"message.diggerhelmet.helmet_broken").m_130940_(ChatFormatting.RED), true);
            player.m_21166_(slot);
        }
    }

    private static void handleCuriosHelmetBreak(Player player, ItemStack helmetStack) {
        if (DiggerHelmetItem.shouldBreakToBroken(helmetStack)) {
            ItemStack brokenHelmet = BrokenDiggerHelmetItem.createBrokenHelmet(helmetStack);
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inv -> inv.findFirstCurio((Item)ModItems.DIGGER_HELMET.get()).ifPresent(curio -> {
                curio.stack().m_41764_(0);
                inv.setEquippedCurio(curio.slotContext().identifier(), curio.slotContext().index(), brokenHelmet);
            }));
            player.m_5661_((Component)Component.m_237115_((String)"message.diggerhelmet.helmet_broken").m_130940_(ChatFormatting.RED), true);
            player.m_21166_(EquipmentSlot.HEAD);
        }
    }
}

