/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.event;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.init.registries.ModTags;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import dev.thomas.diggerhelmet.common.item.MiningSpeedModifier;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

@Mod.EventBusSubscriber(modid="diggerhelmet", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MiningEvents {
    private static final ConcurrentHashMap<Player, HelmetCache> HELMET_CACHE = new ConcurrentHashMap();
    private static final long CACHE_DURATION = 1000L;
    private static final ConcurrentHashMap<Item, Float> TOOL_MULTIPLIER_CACHE = new ConcurrentHashMap();
    private static int cleanupCounter = 0;
    private static final int CLEANUP_INTERVAL = 1200;

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        BlockState state = event.getState();
        ItemStack heldItem = player.m_21205_();
        if (!state.m_204336_(ModTags.Blocks.MINEABLE_WITH_SPEED_BOOSTER)) {
            return;
        }
        if (!player.m_36298_(state)) {
            return;
        }
        ItemStack helmet = MiningEvents.getHelmetFromAnySlotCached(player);
        if (!MiningEvents.hasSpeedModifierCached(helmet, player)) {
            return;
        }
        float multiplier = MiningEvents.getMultiplierCached(heldItem);
        if (multiplier <= 1.0f) {
            return;
        }
        event.setNewSpeed(event.getOriginalSpeed() * multiplier);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MiningEvents.clearPlayerCache(event.getEntity());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++cleanupCounter >= 1200) {
            cleanupCounter = 0;
            MiningEvents.cleanupExpiredCaches();
        }
    }

    private static void cleanupExpiredCaches() {
        HELMET_CACHE.entrySet().removeIf(entry -> ((HelmetCache)entry.getValue()).isExpired());
        if (HELMET_CACHE.size() > 50) {
            // empty if block
        }
    }

    private static boolean hasSpeedModifierCached(ItemStack helmet, Player player) {
        if (helmet.m_41619_()) {
            return false;
        }
        HelmetCache cached = HELMET_CACHE.get(player);
        if (cached != null && !cached.isExpired() && cached.isValid(helmet)) {
            return cached.hasSpeedModifier;
        }
        boolean hasModifier = DiggerHelmetItem.hasSpeedModifier(helmet);
        HELMET_CACHE.put(player, new HelmetCache(hasModifier, helmet));
        return hasModifier;
    }

    private static float getMultiplierCached(ItemStack toolStack) {
        if (toolStack.m_41619_()) {
            return 0.0f;
        }
        Item tool = toolStack.m_41720_();
        return TOOL_MULTIPLIER_CACHE.computeIfAbsent(tool, MiningEvents::computeMultiplier).floatValue();
    }

    private static float computeMultiplier(Item tool) {
        ItemStack stack = new ItemStack((ItemLike)tool);
        if (stack.m_204117_(ItemTags.f_271360_)) {
            return MiningSpeedModifier.getPickaxeMultiplier();
        }
        if (stack.m_204117_(ItemTags.f_271138_)) {
            return MiningSpeedModifier.getShovelMultiplier();
        }
        return 0.0f;
    }

    private static ItemStack getHelmetFromAnySlotCached(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (!helmet.m_41619_() && helmet.m_41720_() instanceof DiggerHelmetItem) {
            return helmet;
        }
        if (!DiggerHelmet.isCuriosLoaded()) {
            return ItemStack.f_41583_;
        }
        try {
            return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().flatMap(handler -> handler.findCurios(stack -> stack.m_41720_() instanceof DiggerHelmetItem).stream().findFirst()).map(SlotResult::stack).orElse(ItemStack.f_41583_);
        }
        catch (Exception e) {
            return ItemStack.f_41583_;
        }
    }

    public static void clearPlayerCache(Player player) {
        HELMET_CACHE.remove(player);
    }

    public static void clearAllCaches() {
        HELMET_CACHE.clear();
        TOOL_MULTIPLIER_CACHE.clear();
    }

    public static String getCacheStats() {
        return String.format("Helmet cache: %d entries, Tool cache: %d entries", HELMET_CACHE.size(), TOOL_MULTIPLIER_CACHE.size());
    }

    private static class HelmetCache {
        final boolean hasSpeedModifier;
        final ItemStack helmet;
        final long timestamp;

        HelmetCache(boolean hasSpeedModifier, ItemStack helmet) {
            this.hasSpeedModifier = hasSpeedModifier;
            this.helmet = helmet.m_41777_();
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 1000L;
        }

        boolean isValid(ItemStack currentHelmet) {
            return ItemStack.m_150942_((ItemStack)this.helmet, (ItemStack)currentHelmet);
        }
    }
}

