/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.client.model.DiggerHelmetModel;
import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.common.item.BrokenDiggerHelmetItem;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import dev.thomas.diggerhelmet.integration.CuriosBrokenHelmetRenderer;
import dev.thomas.diggerhelmet.integration.CuriosHelmetRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="diggerhelmet")
public class CuriosIntegration {
    public static void setup() {
        DiggerHelmet.LOGGER.info("Curios detected - enabling accessory slot support");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(CuriosIntegration::onClientSetup);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            CuriosRendererRegistry.register((Item)((Item)ModItems.DIGGER_HELMET.get()), () -> new CuriosHelmetRenderer(new DiggerHelmetModel()));
            CuriosRendererRegistry.register((Item)((Item)ModItems.BROKEN_DIGGER_HELMET.get()), () -> new CuriosBrokenHelmetRenderer());
        });
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            CuriosIntegration.checkAndUpdateHelmet(event.player);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_()) {
            CuriosIntegration.handleCuriosHelmetDamage(player, event.getAmount());
        }
    }

    private static void checkAndUpdateHelmet(Player player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            handler.findFirstCurio((Item)ModItems.DIGGER_HELMET.get()).ifPresent(curio -> {
                ItemStack helmetStack = curio.stack();
                Item patt3230$temp = helmetStack.m_41720_();
                if (patt3230$temp instanceof DiggerHelmetItem) {
                    DiggerHelmetItem helmetItem = (DiggerHelmetItem)patt3230$temp;
                    helmetItem.onArmorTick(helmetStack, player.m_9236_(), player);
                }
            });
            handler.findFirstCurio((Item)ModItems.BROKEN_DIGGER_HELMET.get()).ifPresent(curio -> {});
        });
    }

    private static void handleCuriosHelmetDamage(Player player, float damageAmount) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio((Item)ModItems.DIGGER_HELMET.get()).ifPresent(curio -> {
            ItemStack helmetStack = curio.stack();
            if (helmetStack.m_41720_() instanceof DiggerHelmetItem) {
                int armorValue = 0;
                Item patt4382$temp = helmetStack.m_41720_();
                if (patt4382$temp instanceof DiggerHelmetItem) {
                    DiggerHelmetItem helmetItem = (DiggerHelmetItem)patt4382$temp;
                    armorValue = helmetItem.m_40401_().m_7366_(ArmorItem.Type.HELMET);
                }
                if (armorValue > 0) {
                    float protectionFactor = 1.0f - (float)armorValue / 25.0f;
                    float helmetDamage = damageAmount / 4.0f * protectionFactor;
                    helmetDamage = Math.max(1.0f, helmetDamage);
                    helmetStack.m_41622_((int)helmetDamage, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.HEAD));
                }
            }
        }));
    }

    public static ICapabilityProvider createCurioProvider(ItemStack stack) {
        return new CurioCapabilityProvider(stack);
    }

    private static class CurioCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<ICurio> curio;
        private final ItemStack stack;

        public CurioCapabilityProvider(ItemStack stack) {
            this.stack = stack;
            this.curio = LazyOptional.of(this::createCurio);
        }

        private ICurio createCurio() {
            return new ICurio(){

                public boolean canEquip(SlotContext slotContext) {
                    LivingEntity entity = slotContext.entity();
                    if (!slotContext.identifier().equals("head")) {
                        return false;
                    }
                    ItemStack vanillaHelmet = entity.m_6844_(EquipmentSlot.HEAD);
                    if (vanillaHelmet.m_41720_() instanceof DiggerHelmetItem || vanillaHelmet.m_41720_() instanceof BrokenDiggerHelmetItem) {
                        return false;
                    }
                    return CuriosApi.getCuriosInventory((LivingEntity)entity).map(inv -> inv.findCurios(stack -> stack.m_41720_() instanceof DiggerHelmetItem || stack.m_41720_() instanceof BrokenDiggerHelmetItem).isEmpty()).orElse(true);
                }

                public ItemStack getStack() {
                    return stack;
                }

                public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                }
            };
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.curio);
        }
    }
}

