/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import dev.thomas.diggerhelmet.integration.TFCAmbientalIntegration;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="diggerhelmet")
public class TFCAmbientalEventHandler {
    public static void handleTemperatureEvent(Object event) {
        if (!TFCAmbientalIntegration.isAvailable()) {
            return;
        }
        try {
            LivingEntity entity = TFCAmbientalEventHandler.extractEntityFromEvent(event);
            if (entity == null) {
                return;
            }
            if (TFCAmbientalIntegration.isWearingTemperatureHelmet(entity)) {
                TFCAmbientalEventHandler.applyTemperatureModifier(event, entity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static LivingEntity extractEntityFromEvent(Object event) {
        try {
            Method getEntityMethod = event.getClass().getMethod("getEntity", new Class[0]);
            Object entity = getEntityMethod.invoke(event, new Object[0]);
            if (entity instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
            Method getPlayerMethod = event.getClass().getMethod("getPlayer", new Class[0]);
            Object player = getPlayerMethod.invoke(event, new Object[0]);
            if (player instanceof Player) {
                return (Player)player;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void applyTemperatureModifier(Object event, LivingEntity entity) {
        try {
            Method getTemperatureMethod = event.getClass().getMethod("getTemperature", new Class[0]);
            float currentTemp = ((Float)getTemperatureMethod.invoke(event, new Object[0])).floatValue();
            ItemStack helmet = TFCAmbientalEventHandler.getDiggerHelmet(entity);
            if (helmet.m_41619_()) {
                return;
            }
            float modifier = TFCAmbientalIntegration.getTemperatureModifier(helmet);
            float newTemp = currentTemp + modifier;
            Method setTemperatureMethod = event.getClass().getMethod("setTemperature", Float.TYPE);
            setTemperatureMethod.invoke(event, Float.valueOf(newTemp));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ItemStack getDiggerHelmet(LivingEntity entity) {
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41720_() instanceof DiggerHelmetItem) {
            return helmet;
        }
        if (DiggerHelmet.isCuriosLoaded()) {
            return TFCAmbientalEventHandler.getCuriosHelmet(entity);
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getCuriosHelmet(LivingEntity entity) {
        try {
            Predicate<ItemStack> helmetPredicate;
            Method getMethod;
            Object curiosInventory;
            Method findCuriosMethod;
            List results;
            Method isPresentMethod;
            boolean isPresent;
            Class<?> curiosApiClass = Class.forName("top.theillusivec4.curios.api.CuriosApi");
            Method getCuriosInventoryMethod = curiosApiClass.getMethod("getCuriosInventory", LivingEntity.class);
            Object curiosInventoryOptional = getCuriosInventoryMethod.invoke(null, entity);
            if (curiosInventoryOptional != null && (isPresent = ((Boolean)(isPresentMethod = curiosInventoryOptional.getClass().getMethod("isPresent", new Class[0])).invoke(curiosInventoryOptional, new Object[0])).booleanValue()) && !(results = (List)(findCuriosMethod = (curiosInventory = (getMethod = curiosInventoryOptional.getClass().getMethod("get", new Class[0])).invoke(curiosInventoryOptional, new Object[0])).getClass().getMethod("findCurios", Predicate.class)).invoke(curiosInventory, helmetPredicate = stack -> stack.m_41720_() instanceof DiggerHelmetItem)).isEmpty()) {
                Object slotResult = results.get(0);
                Method stackMethod = slotResult.getClass().getMethod("stack", new Class[0]);
                return (ItemStack)stackMethod.invoke(slotResult, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ItemStack.f_41583_;
    }
}

