/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration;

import dev.thomas.diggerhelmet.DiggerHelmet;
import dev.thomas.diggerhelmet.common.item.DiggerHelmetItem;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class TFCAmbientalIntegration {
    private static final String TFC_AMBIENTAL_MODID = "tfcambiental";
    private static final ConcurrentHashMap<String, Method> METHOD_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();
    private static final float WOOL_WARMING = 4.0f;
    private static final float WOOL_INSULATION = 1.5f;
    private static final float SILK_WARMING = -1.0f;
    private static final float SILK_INSULATION = 1.0f;
    private static volatile boolean initialized = false;
    private static volatile boolean integrationEnabled = false;

    public static boolean isAvailable() {
        return ModList.get().isLoaded(TFC_AMBIENTAL_MODID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (initialized) {
            return;
        }
        Class<TFCAmbientalIntegration> clazz = TFCAmbientalIntegration.class;
        synchronized (TFCAmbientalIntegration.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (!TFCAmbientalIntegration.isAvailable()) {
                initialized = true;
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            DiggerHelmet.LOGGER.info("Initializing TFC Ambiental integration...");
            try {
                TFCAmbientalIntegration.setupIntegration();
                integrationEnabled = true;
                DiggerHelmet.LOGGER.info("TFC Ambiental integration initialized successfully");
            }
            catch (Exception e) {
                DiggerHelmet.LOGGER.warn("Failed to initialize TFC Ambiental integration", (Throwable)e);
                DiggerHelmet.LOGGER.info("Mod will continue without temperature features");
                integrationEnabled = false;
            }
            finally {
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void setupIntegration() throws Exception {
        Class<?> ambientalRegistryClass = TFCAmbientalIntegration.getClassSafely("com.lumintorious.tfcambiental.api.AmbientalRegistry");
        Class<?> equipmentProviderClass = TFCAmbientalIntegration.getClassSafely("com.lumintorious.tfcambiental.api.EquipmentTemperatureProvider");
        Class<?> tempModifierClass = TFCAmbientalIntegration.getClassSafely("com.lumintorious.tfcambiental.modifier.TempModifier");
        if (ambientalRegistryClass == null || equipmentProviderClass == null || tempModifierClass == null) {
            throw new ClassNotFoundException("Required TFC Ambiental classes not found");
        }
        Field equipmentField = ambientalRegistryClass.getField("EQUIPMENT");
        Object equipmentRegistry = equipmentField.get(null);
        if (equipmentRegistry == null) {
            throw new IllegalStateException("AmbientalRegistry.EQUIPMENT is null");
        }
        Method[] methods = equipmentRegistry.getClass().getMethods();
        Method registerMethod = null;
        for (Method method : methods) {
            Class<?>[] paramTypes;
            if (!method.getName().equals("register") || (paramTypes = method.getParameterTypes()).length != 1 || !paramTypes[0].isAssignableFrom(equipmentProviderClass)) continue;
            registerMethod = method;
            break;
        }
        if (registerMethod == null) {
            throw new NoSuchMethodException("AmbientalRegistry.register method not found with EquipmentTemperatureProvider parameter");
        }
        Object helmetProvider = TFCAmbientalIntegration.createHelmetProvider(equipmentProviderClass, tempModifierClass);
        try {
            registerMethod.invoke(equipmentRegistry, helmetProvider);
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Failed to register helmet provider", (Throwable)e);
            throw e;
        }
    }

    private static Class<?> getClassSafely(String className) {
        return CLASS_CACHE.computeIfAbsent(className, name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
    }

    private static Method getMethodSafely(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        String key = clazz.getName() + "." + methodName;
        return METHOD_CACHE.computeIfAbsent(key, k -> {
            try {
                Method method = clazz.getMethod(methodName, paramTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        });
    }

    private static boolean isTemperatureAffectingHelmet(ItemStack stack) {
        if (!(stack.m_41720_() instanceof DiggerHelmetItem)) {
            return false;
        }
        return DiggerHelmetItem.hasWoolLining(stack) || DiggerHelmetItem.hasSilkLining(stack);
    }

    private static Object createTempModifier(ItemStack stack, Class<?> tempModifierClass) {
        try {
            String modifierName;
            float insulation;
            float warming;
            String liningType = DiggerHelmetItem.getLiningType(stack);
            if (liningType == null) {
                return TFCAmbientalIntegration.createEmptyModifier(tempModifierClass);
            }
            switch (liningType) {
                case "wool": {
                    warming = 4.0f;
                    insulation = 1.5f;
                    modifierName = "digger_helmet_wool";
                    break;
                }
                case "silk": {
                    warming = -1.0f;
                    insulation = 1.0f;
                    modifierName = "digger_helmet_silk";
                    break;
                }
                default: {
                    return TFCAmbientalIntegration.createEmptyModifier(tempModifierClass);
                }
            }
            return tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance(modifierName, Float.valueOf(warming), Float.valueOf(insulation));
        }
        catch (Exception e) {
            return TFCAmbientalIntegration.createEmptyModifier(tempModifierClass);
        }
    }

    private static Object createEmptyModifier(Class<?> tempModifierClass) {
        try {
            return tempModifierClass.getConstructor(String.class, Float.TYPE, Float.TYPE).newInstance("digger_helmet_empty", Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        catch (Exception e) {
            DiggerHelmet.LOGGER.warn("Failed to create empty temperature modifier", (Throwable)e);
            return null;
        }
    }

    private static Object createHelmetProvider(Class<?> equipmentProviderClass, Class<?> tempModifierClass) {
        return Proxy.newProxyInstance(equipmentProviderClass.getClassLoader(), new Class[]{equipmentProviderClass}, (proxy, method, args) -> {
            if (method.getName().equals("getModifier")) {
                Object tempModifier;
                ItemStack stack = (ItemStack)args[1];
                if (TFCAmbientalIntegration.isTemperatureAffectingHelmet(stack) && (tempModifier = TFCAmbientalIntegration.createTempModifier(stack, tempModifierClass)) != null) {
                    return Optional.of(tempModifier);
                }
                return Optional.empty();
            }
            return null;
        });
    }

    public static boolean isWearingTemperatureHelmet(LivingEntity entity) {
        if (!integrationEnabled) {
            return false;
        }
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        if (TFCAmbientalIntegration.isTemperatureAffectingHelmet(helmet)) {
            return true;
        }
        if (DiggerHelmet.isCuriosLoaded()) {
            return TFCAmbientalIntegration.checkCuriosForTemperatureHelmet(entity);
        }
        return false;
    }

    private static boolean checkCuriosForTemperatureHelmet(LivingEntity entity) {
        try {
            Class<?> curiosApiClass = TFCAmbientalIntegration.getClassSafely("top.theillusivec4.curios.api.CuriosApi");
            if (curiosApiClass == null) {
                return false;
            }
            Method getCuriosMethod = TFCAmbientalIntegration.getMethodSafely(curiosApiClass, "getCuriosInventory", LivingEntity.class);
            if (getCuriosMethod == null) {
                return false;
            }
            Object curiosOptional = getCuriosMethod.invoke(null, entity);
            if (curiosOptional == null) {
                return false;
            }
            Method isPresentMethod = TFCAmbientalIntegration.getMethodSafely(curiosOptional.getClass(), "isPresent", new Class[0]);
            if (isPresentMethod == null || !((Boolean)isPresentMethod.invoke(curiosOptional, new Object[0])).booleanValue()) {
                return false;
            }
            Method getMethod = TFCAmbientalIntegration.getMethodSafely(curiosOptional.getClass(), "get", new Class[0]);
            if (getMethod == null) {
                return false;
            }
            Object curiosInventory = getMethod.invoke(curiosOptional, new Object[0]);
            Method findCuriosMethod = TFCAmbientalIntegration.getMethodSafely(curiosInventory.getClass(), "findCurios", Predicate.class);
            if (findCuriosMethod == null) {
                return false;
            }
            List results = (List)findCuriosMethod.invoke(curiosInventory, TFCAmbientalIntegration::isTemperatureAffectingHelmet);
            return !results.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static float getTemperatureModifier(ItemStack helmetStack) {
        if (!integrationEnabled || !TFCAmbientalIntegration.isTemperatureAffectingHelmet(helmetStack)) {
            return 0.0f;
        }
        String liningType = DiggerHelmetItem.getLiningType(helmetStack);
        if (liningType == null) {
            return 0.0f;
        }
        switch (liningType) {
            case "wool": {
                return 4.0f;
            }
            case "silk": {
                return -1.0f;
            }
        }
        return 0.0f;
    }

    public static float getInsulationValue(ItemStack helmetStack) {
        if (!integrationEnabled || !TFCAmbientalIntegration.isTemperatureAffectingHelmet(helmetStack)) {
            return 0.0f;
        }
        String liningType = DiggerHelmetItem.getLiningType(helmetStack);
        if (liningType == null) {
            return 0.0f;
        }
        switch (liningType) {
            case "wool": {
                return 1.5f;
            }
            case "silk": {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    public static boolean isIntegrationEnabled() {
        return integrationEnabled;
    }

    public static void clearCache() {
        METHOD_CACHE.clear();
        CLASS_CACHE.clear();
    }
}

