/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration.jei;

import dev.thomas.diggerhelmet.integration.jei.HelmetRepairRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class HelmetRepairCategory
implements IRecipeCategory<HelmetRepairRecipe> {
    public static final RecipeType<HelmetRepairRecipe> RECIPE_TYPE = RecipeType.create((String)"diggerhelmet", (String)"helmet_repair", HelmetRepairRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableStatic slot;
    private final IDrawableStatic arrow;
    private final IDrawableAnimated arrowAnimated;

    public HelmetRepairCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(136, 74);
        this.icon = guiHelper.createDrawableItemLike((ItemLike)Items.f_41960_);
        this.slot = guiHelper.getSlotDrawable();
        this.arrow = guiHelper.getRecipeArrow();
        this.arrowAnimated = guiHelper.createAnimatedDrawable(this.arrow, 80, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<HelmetRepairRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"jei.diggerhelmet.category.helmet_repair");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull HelmetRepairRecipe recipe, @NotNull IFocusGroup focuses) {
        IRecipeSlotBuilder helmetSlot = builder.addSlot(RecipeIngredientRole.INPUT, 26, 5);
        helmetSlot.addItemStack(recipe.getDamagedHelmet());
        helmetSlot.setBackground((IDrawable)this.slot, -1, -1);
        IRecipeSlotBuilder materialSlot = builder.addSlot(RecipeIngredientRole.INPUT, 6, 5);
        materialSlot.addItemStack(recipe.getRepairMaterial());
        materialSlot.setBackground((IDrawable)this.slot, -1, -1);
        IRecipeSlotBuilder candleSlot = builder.addSlot(RecipeIngredientRole.INPUT, 46, 5);
        candleSlot.addIngredients(recipe.getTFCCandleIngredient());
        candleSlot.setBackground((IDrawable)this.slot, -1, -1);
        IRecipeSlotBuilder scissorsSlot = builder.addSlot(RecipeIngredientRole.INPUT, 26, 25);
        scissorsSlot.addIngredients(recipe.getTFCShearsIngredient());
        scissorsSlot.setBackground((IDrawable)this.slot, -1, -1);
        IRecipeSlotBuilder outputSlot = builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 15);
        outputSlot.addItemStack(recipe.getRepairedHelmet());
        outputSlot.setBackground((IDrawable)this.slot, -1, -1);
    }

    public void draw(@NotNull HelmetRepairRecipe recipe, @NotNull IRecipeSlotsView recipeSlots, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 68, 10);
        this.arrowAnimated.draw(guiGraphics, 68, 10);
    }

    public ResourceLocation getRegistryName(@NotNull HelmetRepairRecipe recipe) {
        return recipe.getId();
    }
}

