/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration.jei;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class HelmetRepairRecipe {
    private final ResourceLocation id;
    private final ItemStack damagedHelmet;
    private final ItemStack repairMaterial;
    private final ItemStack candle;
    private final ItemStack scissors;
    private final ItemStack repairedHelmet;
    private final int durabilityRestored;
    private final float repairPercentage;

    public HelmetRepairRecipe(ResourceLocation id, ItemStack damagedHelmet, ItemStack repairMaterial, ItemStack candle, ItemStack scissors, ItemStack repairedHelmet, int durabilityRestored, float repairPercentage) {
        this.id = id;
        this.damagedHelmet = damagedHelmet;
        this.repairMaterial = repairMaterial;
        this.candle = candle;
        this.scissors = scissors;
        this.repairedHelmet = repairedHelmet;
        this.durabilityRestored = durabilityRestored;
        this.repairPercentage = repairPercentage;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ItemStack getDamagedHelmet() {
        return this.damagedHelmet;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public ItemStack getRepairItem() {
        return this.repairMaterial;
    }

    public ItemStack getCandle() {
        return this.candle;
    }

    public ItemStack getScissors() {
        return this.scissors;
    }

    public ItemStack getRepairedHelmet() {
        return this.repairedHelmet;
    }

    public int getDurabilityRestored() {
        return this.durabilityRestored;
    }

    public float getRepairPercentage() {
        return this.repairPercentage;
    }

    public int getMaxDurability() {
        return this.repairedHelmet.m_41776_();
    }

    public int getCurrentDurability() {
        return this.getMaxDurability() - this.damagedHelmet.m_41773_();
    }

    public int getDurabilityAfterRepair() {
        return this.getCurrentDurability() + this.durabilityRestored;
    }

    public Ingredient getTFCShearsIngredient() {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"shears")));
    }

    public Ingredient getTFCCandleIngredient() {
        return Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"candles")));
    }
}

