/*
 * Decompiled with CFR 0.152.
 */
package dev.thomas.diggerhelmet.integration.jei;

import dev.thomas.diggerhelmet.common.init.registries.ModItems;
import dev.thomas.diggerhelmet.integration.jei.HelmetRepairRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class HelmetRepairRecipeGenerator {
    private static final int MAX_DURABILITY = 130;
    private static final int REPAIR_PER_INGOT = 78;

    public static List<HelmetRepairRecipe> getRepairRecipes() {
        ArrayList<HelmetRepairRecipe> recipes = new ArrayList<HelmetRepairRecipe>();
        recipes.add(HelmetRepairRecipeGenerator.createRepairRecipe("repair_25", 0.25f));
        recipes.add(HelmetRepairRecipeGenerator.createRepairRecipe("repair_50", 0.5f));
        recipes.add(HelmetRepairRecipeGenerator.createRepairRecipe("repair_75", 0.75f));
        recipes.add(HelmetRepairRecipeGenerator.createBrokenHelmetRecipe("broken"));
        return recipes;
    }

    private static HelmetRepairRecipe createRepairRecipe(String id, float damagePercentage) {
        ItemStack damagedHelmet = new ItemStack((ItemLike)ModItems.DIGGER_HELMET.get());
        int damage = (int)(130.0f * damagePercentage);
        damagedHelmet.m_41721_(damage);
        ItemStack repairMaterial = new ItemStack((ItemLike)Items.f_42454_);
        ItemStack candle = ItemStack.f_41583_;
        ItemStack scissors = ItemStack.f_41583_;
        ItemStack repairedHelmet = new ItemStack((ItemLike)ModItems.DIGGER_HELMET.get());
        int newDamage = Math.max(0, damage - 78);
        repairedHelmet.m_41721_(newDamage);
        int durabilityRestored = damage - newDamage;
        float repairPercentage = (float)durabilityRestored / 130.0f * 100.0f;
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"diggerhelmet", (String)("helmet_repair_" + id));
        return new HelmetRepairRecipe(recipeId, damagedHelmet, repairMaterial, candle, scissors, repairedHelmet, durabilityRestored, repairPercentage);
    }

    private static HelmetRepairRecipe createBrokenHelmetRecipe(String id) {
        ItemStack brokenHelmet = new ItemStack((ItemLike)ModItems.BROKEN_DIGGER_HELMET.get());
        ItemStack repairMaterial = new ItemStack((ItemLike)Items.f_42454_);
        ItemStack candle = ItemStack.f_41583_;
        ItemStack scissors = ItemStack.f_41583_;
        ItemStack repairedHelmet = new ItemStack((ItemLike)ModItems.DIGGER_HELMET.get());
        int newDurability = 78;
        repairedHelmet.m_41721_(130 - newDurability);
        int durabilityRestored = newDurability;
        float repairPercentage = 60.0f;
        ResourceLocation recipeId = ResourceLocation.fromNamespaceAndPath((String)"diggerhelmet", (String)("helmet_repair_" + id));
        return new HelmetRepairRecipe(recipeId, brokenHelmet, repairMaterial, candle, scissors, repairedHelmet, durabilityRestored, repairPercentage);
    }
}

