/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.damageIndicators;

import com.lightre.damageIndicators.commands.Di;
import com.lightre.damageIndicators.listeners.EntityDamage;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DamageIndicators
extends JavaPlugin {
    private boolean indicatorsEnabled = true;
    private String indicatorPrefix;
    private String criticalIndicatorPrefix;
    private long indicatorDurationTicks;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDamage(this), (Plugin)this);
        this.getCommand("di").setExecutor((CommandExecutor)new Di(this));
        this.getLogger().info("DamageIndicators enabled!");
    }

    public void onDisable() {
        this.getLogger().info("DamageIndicators disabled!");
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        if (this.getConfig().isString("indicator-prefix")) {
            this.indicatorPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("indicator-prefix"));
        } else {
            this.getLogger().warning("'indicator-prefix' is missing or invalid in the config! Default value '&c\u2764 ' will be used");
            this.indicatorPrefix = "\u00a7c\u2764 ";
        }
        if (this.getConfig().isString("critical-indicator-prefix")) {
            this.criticalIndicatorPrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("critical-indicator-prefix"));
        } else {
            this.getLogger().warning("'critical-indicator-prefix' is missing or invalid in the config! Default value '&e\u272f ' will be used.");
            this.criticalIndicatorPrefix = "\u00a7e\u272f ";
        }
        if (this.getConfig().isDouble("indicator-duration-seconds") || this.getConfig().isInt("indicator-duration-seconds")) {
            this.indicatorDurationTicks = (long)(this.getConfig().getDouble("indicator-duration-seconds") * 20.0);
        } else {
            this.getLogger().warning("'indicator-duration-seconds' is missing or invalid in the config! Default value '2.0' will be used.");
            this.indicatorDurationTicks = 40L;
        }
    }

    public String getCriticalIndicatorPrefix() {
        return this.criticalIndicatorPrefix;
    }

    public String getIndicatorPrefix() {
        return this.indicatorPrefix;
    }

    public long getIndicatorDurationTicks() {
        return this.indicatorDurationTicks;
    }

    public boolean isIndicatorsEnabled() {
        return this.indicatorsEnabled;
    }

    public void setIndicatorsEnabled(boolean indicatorsEnabled) {
        this.indicatorsEnabled = indicatorsEnabled;
    }
}

