/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.damageIndicators.commands;

import com.lightre.damageIndicators.DamageIndicators;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Di(DamageIndicators plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: /di <toggle|reload|help>");
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("toggle")) {
            if (!sender.hasPermission("damageindicators.toggle")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command!");
                return true;
            }
            boolean newState = !this.plugin.isIndicatorsEnabled();
            this.plugin.setIndicatorsEnabled(newState);
            if (newState) {
                sender.sendMessage("\u00a7aDamage Indicators Enabled.");
            } else {
                sender.sendMessage("\u00a7cDamage Indicators Disabled.");
            }
        } else if (subCommand.equals("reload")) {
            if (!sender.hasPermission("damageindicators.reload")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command!");
                return true;
            }
            this.plugin.reloadConfiguration();
            sender.sendMessage("\u00a7aDamageIndicators config file reloaded!");
        } else if (subCommand.equals("help")) {
            if (!sender.hasPermission("damageindicators.help")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command!");
                return true;
            }
            PluginDescriptionFile desc = this.plugin.getDescription();
            String authors = String.join((CharSequence)", ", desc.getAuthors());
            sender.sendMessage("\u00a78\u00a7m----------------------------------");
            sender.sendMessage(" \u00a7e" + desc.getName() + " \u00a77v" + desc.getVersion());
            sender.sendMessage(" \u00a77Created by: \u00a7b" + authors);
            sender.sendMessage("");
            sender.sendMessage(" \u00a77Available Commands:");
            sender.sendMessage(" \u00a7e/di help   \u00a78- \u00a77Displays this help message.");
            sender.sendMessage(" \u00a7e/di reload \u00a78- \u00a77Reloads the configuration file.");
            sender.sendMessage(" \u00a7e/di toggle \u00a78- \u00a77Toggles indicators on or off.");
            sender.sendMessage("\u00a78\u00a7m----------------------------------");
        } else {
            sender.sendMessage("\u00a7cUnknown command. Usage: \u00a77/di \u00a7e<toggle|reload|help>");
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("damageindicators.help")) {
                completions.add("help");
            }
            if (sender.hasPermission("damageindicators.toggle")) {
                completions.add("toggle");
            }
            if (sender.hasPermission("damageindicators.reload")) {
                completions.add("reload");
            }
            return (List)StringUtil.copyPartialMatches((String)args[0], completions, new ArrayList());
        }
        return new ArrayList<String>();
    }
}

