/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.damageIndicators.listeners;

import com.lightre.damageIndicators.DamageIndicators;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public record EntityDamage(DamageIndicators plugin) implements Listener
{
    @EventHandler
    public void onEntityDamageEvent(EntityDamageEvent event) {
        Location baseLocation;
        String prefix;
        if (!this.plugin.isIndicatorsEnabled() || event.getFinalDamage() < 0.1) {
            return;
        }
        Entity victim = event.getEntity();
        double damage = event.getFinalDamage();
        String formattedDamage = String.format("%.1f", damage);
        long durationInTicks = this.plugin.getIndicatorDurationTicks();
        if (event instanceof EntityDamageByEntityEvent) {
            Projectile projectile;
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
            Entity damager = entityEvent.getDamager();
            prefix = entityEvent.isCritical() ? this.plugin.getCriticalIndicatorPrefix() : this.plugin.getIndicatorPrefix();
            if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() instanceof Entity) {
                damager = (Entity)projectile.getShooter();
            }
            Vector direction = victim.getLocation().toVector().subtract(damager.getLocation().toVector()).normalize();
            baseLocation = victim.getLocation().add(0.0, victim.getHeight() / 2.0, 0.0).add(direction.multiply(-0.8));
        } else {
            prefix = this.plugin.getIndicatorPrefix();
            baseLocation = victim.getLocation().add(ThreadLocalRandom.current().nextDouble(-1.0, 1.0), 0.5 + ThreadLocalRandom.current().nextDouble(0.0, 1.0), ThreadLocalRandom.current().nextDouble(-1.0, 1.0));
        }
        TextComponent damageText = Component.text((String)(prefix + formattedDamage));
        double spread = 0.5;
        Location finalSpawnLocation = baseLocation.add(ThreadLocalRandom.current().nextDouble(-spread, spread), ThreadLocalRandom.current().nextDouble(-spread, spread), ThreadLocalRandom.current().nextDouble(-spread, spread));
        victim.getWorld().spawn(finalSpawnLocation, TextDisplay.class, arg_0 -> this.lambda$onEntityDamageEvent$0((Component)damageText, durationInTicks, arg_0));
    }

    private /* synthetic */ void lambda$onEntityDamageEvent$0(Component damageText, long durationInTicks, TextDisplay indicator) {
        indicator.text(damageText);
        indicator.setBillboard(Display.Billboard.CENTER);
        indicator.setShadowed(true);
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> ((TextDisplay)indicator).remove(), durationInTicks);
    }
}

