/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.damageindicators.commands;

import com.lightre.damageindicators.DamageIndicators;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class Di
implements CommandExecutor,
TabCompleter {
    private final DamageIndicators plugin;

    public Di(DamageIndicators plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: /di <toggle|reload|help>");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "toggle": {
                if (!sender.hasPermission("damageindicators.toggle")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command!");
                    return true;
                }
                try {
                    boolean newState = this.toggleEnabledInConfigFile();
                    this.plugin.reloadConfiguration();
                    if (newState) {
                        sender.sendMessage("\u00a7aDamage Indicators enabled and saved to config.");
                        break;
                    }
                    sender.sendMessage("\u00a7cDamage Indicators disabled and saved to config.");
                }
                catch (IOException e) {
                    sender.sendMessage("\u00a7cError: Could not save the config file. Check the console for details.");
                    e.printStackTrace();
                }
                break;
            }
            case "reload": {
                if (!sender.hasPermission("damageindicators.reload")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command!");
                    return true;
                }
                this.plugin.reloadConfiguration();
                sender.sendMessage("\u00a7aDamageIndicators config file reloaded!");
                break;
            }
            case "help": {
                if (!sender.hasPermission("damageindicators.help")) {
                    sender.sendMessage("\u00a7cYou do not have permission to use this command!");
                    return true;
                }
                PluginDescriptionFile desc = this.plugin.getDescription();
                sender.sendMessage("\u00a78\u00a7m----------------------------------");
                sender.sendMessage(" \u00a7e" + desc.getName() + " \u00a77v" + desc.getVersion());
                sender.sendMessage(" \u00a77Created by: \u00a7b" + String.join((CharSequence)", ", desc.getAuthors()));
                sender.sendMessage("");
                sender.sendMessage(" \u00a7e/di toggle \u00a78- \u00a77Toggles indicators and saves to config.");
                sender.sendMessage(" \u00a7e/di reload \u00a78- \u00a77Reloads the configuration file.");
                sender.sendMessage(" \u00a7e/di help   \u00a78- \u00a77Displays this help message.");
                sender.sendMessage("\u00a78\u00a7m----------------------------------");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown command. Usage: \u00a77/di <toggle|reload|help>");
            }
        }
        return true;
    }

    private boolean toggleEnabledInConfigFile() throws IOException {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        List<String> lines = Files.readAllLines(configFile.toPath());
        ArrayList<Object> newLines = new ArrayList<Object>();
        boolean newState = !this.plugin.getConfig().getBoolean("enabled");
        for (String line : lines) {
            if (line.trim().startsWith("enabled:")) {
                String string = line.substring(0, line.indexOf("enabled:"));
                newLines.add(string + "enabled: " + newState);
                continue;
            }
            newLines.add(line);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));){
            for (String string : newLines) {
                writer.write(string + System.lineSeparator());
            }
        }
        return newState;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>(List.of("help", "toggle", "reload"));
            return (List)StringUtil.copyPartialMatches((String)args[0], completions, new ArrayList());
        }
        return new ArrayList<String>();
    }
}

