/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.damageindicators.listeners;

import com.lightre.damageindicators.DamageIndicators;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public final class EntityDamage
implements Listener {
    private final DamageIndicators plugin;

    public EntityDamage(DamageIndicators plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityDamageEvent(EntityDamageEvent event) {
        Location baseLocation;
        String worldName = event.getEntity().getWorld().getName().toLowerCase();
        if (this.plugin.getDisabledWorldsList().contains(worldName) || event.getFinalDamage() < 0.1) {
            return;
        }
        Entity victim = event.getEntity();
        double damage = event.getFinalDamage();
        String formattedDamage = String.format("%.1f", damage);
        long durationInTicks = this.plugin.getIndicatorDurationTicks();
        String prefix = this.plugin.getIndicatorPrefix();
        if (event instanceof EntityDamageByEntityEvent) {
            Projectile projectile;
            ProjectileSource projectileSource;
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
            Entity damager = entityEvent.getDamager();
            if (damager instanceof Projectile && (projectileSource = (projectile = (Projectile)damager).getShooter()) instanceof Entity) {
                Entity shooter;
                damager = shooter = (Entity)projectileSource;
            }
            Vector direction = victim.getLocation().toVector().subtract(damager.getLocation().toVector()).normalize();
            baseLocation = victim.getLocation().add(0.0, victim.getHeight() / 2.0, 0.0).add(direction.multiply(-0.8));
        } else {
            baseLocation = victim.getLocation().add(ThreadLocalRandom.current().nextDouble(-1.0, 1.0), 0.5 + ThreadLocalRandom.current().nextDouble(0.0, 1.0), ThreadLocalRandom.current().nextDouble(-1.0, 1.0));
        }
        double spread = 0.5;
        Location finalSpawnLocation = baseLocation.add(ThreadLocalRandom.current().nextDouble(-spread, spread), ThreadLocalRandom.current().nextDouble(-spread, spread), ThreadLocalRandom.current().nextDouble(-spread, spread));
        victim.getWorld().spawn(finalSpawnLocation, ArmorStand.class, armorStand -> {
            armorStand.setMetadata("damageindicators.indicator", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            armorStand.setMarker(true);
            armorStand.setSmall(true);
            armorStand.setInvulnerable(true);
            String damageText = ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + formattedDamage));
            armorStand.setCustomName(damageText);
            armorStand.setCustomNameVisible(true);
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> ((ArmorStand)armorStand).remove(), durationInTicks);
        });
    }
}

