/*
 * Decompiled with CFR 0.152.
 */
package com.lightre.damageindicators;

import com.lightre.damageindicators.commands.Di;
import com.lightre.damageindicators.listeners.EntityDamage;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DamageIndicators
extends JavaPlugin {
    private boolean indicatorsEnabled;
    private String indicatorPrefix;
    private long indicatorDurationTicks;
    private List<String> disabledWorldsList;
    private static final Pattern VALID_WORLD_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-]+$");

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getCommand("di").setExecutor((CommandExecutor)new Di(this));
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        this.loadConfigValues();
    }

    private void loadConfigValues() {
        HandlerList.unregisterAll((Plugin)this);
        this.indicatorsEnabled = this.getConfig().getBoolean("enabled");
        if (this.indicatorsEnabled) {
            this.getServer().getPluginManager().registerEvents((Listener)new EntityDamage(this), (Plugin)this);
            this.getLogger().info("Indicators are ENABLED. Listener registered.");
        } else {
            this.getLogger().info("Indicators are DISABLED in config.yml. Listener not registered.");
        }
        this.indicatorPrefix = this.getConfig().getString("indicator-prefix", "&c\u2665 ");
        double durationInSeconds = this.getConfig().getDouble("indicator-duration-seconds", 1.5);
        this.indicatorDurationTicks = (long)(durationInSeconds * 20.0);
        this.disabledWorldsList = new ArrayList<String>();
        List rawListFromConfig = this.getConfig().getStringList("disabled-worlds");
        for (String worldName : rawListFromConfig) {
            if (worldName != null && VALID_WORLD_NAME_PATTERN.matcher(worldName).matches()) {
                this.disabledWorldsList.add(worldName.toLowerCase());
                continue;
            }
            this.getLogger().warning("Invalid entry in 'disabled-worlds': '" + worldName + "'. It has been ignored.");
        }
    }

    public String getIndicatorPrefix() {
        return this.indicatorPrefix;
    }

    public long getIndicatorDurationTicks() {
        return this.indicatorDurationTicks;
    }

    public List<String> getDisabledWorldsList() {
        return this.disabledWorldsList;
    }
}

