/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.crafterscombatlogs;

import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import one.crafters.crafterscombatlogs.events.PetKillListener;
import one.crafters.crafterscombatlogs.events.PlayerCombatLogs;
import one.crafters.crafterscombatlogs.events.PlayerDeaths;
import one.crafters.crafterscombatlogs.events.TotemPop;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CraftersCombatLogs
extends JavaPlugin {
    private static CraftersCombatLogs PLUGIN;
    private JDA discordBot;

    public void onEnable() {
        PLUGIN = this;
        this.saveDefaultConfig();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerCombatLogs(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerDeaths(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new TotemPop(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PetKillListener(), (Plugin)this);
        String discordToken = this.getConfig().getString("settings.discord_token");
        if (discordToken == null || discordToken.equals("YOUR_DISCORD_BOT_TOKEN")) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.getLogger().severe("Please set your discord token in the config.yml");
            return;
        }
        try {
            JDABuilder builder = JDABuilder.createDefault(discordToken);
            this.discordBot = builder.build();
            this.getLogger().info("Discord bot connected successfully.");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to log in to the Discord bot. Please check your token.");
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("CraftersCombatLogs has been enabled.");
    }

    public JDA getDiscordBot() {
        return this.discordBot;
    }

    public static CraftersCombatLogs getInstance() {
        return PLUGIN;
    }
}

