/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.crafterscombatlogs.data;

import java.awt.Color;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;

public class FightSession {
    private final UUID playerA;
    private final UUID playerB;
    private final List<String> logLines;
    private final Instant startTime;
    private Instant lastHitTime;

    public FightSession(UUID playerA, UUID playerB) {
        this.playerA = playerA;
        this.playerB = playerB;
        this.lastHitTime = this.startTime = Instant.now();
        this.logLines = new ArrayList<String>();
    }

    public void addHit(String attacker, String victim, int damage) {
        this.logLines.add(attacker + " hit " + victim + " for " + damage + " damage");
        this.lastHitTime = Instant.now();
    }

    public boolean isExpired() {
        return Instant.now().toEpochMilli() - this.lastHitTime.toEpochMilli() > 30000L;
    }

    public String getFormattedLog() {
        return "```" + String.join((CharSequence)"\n", this.logLines) + "```";
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public MessageEmbed toEmbed(String worldName, String coords, UUID thumbnailUUID) {
        EmbedBuilder embed = new EmbedBuilder();
        embed.setColor(Color.DARK_GRAY);
        embed.setAuthor("Crafter's Combat Logs | PvP Exchange", "https://wiki.crafters.one/wiki/Crafters_Combat_Logs", "https://crafters.one/img/craftersiconsmall.png");
        embed.setDescription(this.getFormattedLog());
        embed.setThumbnail("https://mc-heads.net/avatar/" + String.valueOf(thumbnailUUID));
        embed.addField("World", worldName, true);
        embed.addField("Coords", coords, true);
        embed.setFooter("Fight started at: " + this.formatTimestamp(this.startTime));
        return embed.build();
    }

    private String formatTimestamp(Instant instant) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault()).format(instant);
    }

    public boolean involves(UUID a, UUID b) {
        return a.equals(this.playerA) && b.equals(this.playerB) || a.equals(this.playerB) && b.equals(this.playerA);
    }
}

