/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.crafterscombatlogs.events;

import java.awt.Color;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import one.crafters.crafterscombatlogs.CraftersCombatLogs;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

public class PetKillListener
implements Listener {
    private final CraftersCombatLogs plugin = CraftersCombatLogs.getInstance();
    private final FileConfiguration config = this.plugin.getConfig();

    private String formatCoords(LivingEntity entity) {
        String worldName = switch (entity.getWorld().getEnvironment()) {
            case World.Environment.NORMAL -> "Overworld";
            case World.Environment.NETHER -> "Nether";
            case World.Environment.THE_END -> "The End";
            default -> entity.getWorld().getName();
        };
        return "`" + entity.getLocation().getBlockX() + " " + entity.getLocation().getBlockY() + " " + entity.getLocation().getBlockZ() + "` (" + worldName + ")";
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        AnimalTamer owner;
        Tameable tameable;
        LivingEntity entity = event.getEntity();
        Player killer = entity.getKiller();
        if (killer == null) {
            return;
        }
        if (entity instanceof Tameable && (tameable = (Tameable)entity).isTamed() && (owner = tameable.getOwner()) instanceof Player) {
            Player ownerPlayer = (Player)owner;
            String coords = this.formatCoords(entity);
            String ownershipText = ownerPlayer.getUniqueId().equals(killer.getUniqueId()) ? "their own tamed" : ownerPlayer.getName() + "'s tamed";
            EmbedBuilder embedBuilder = new EmbedBuilder();
            embedBuilder.setColor(Color.RED);
            embedBuilder.setAuthor(killer.getName() + " killed " + ownershipText + " " + this.formatType((Entity)entity), null, "https://mc-heads.net/avatar/" + String.valueOf(killer.getUniqueId())).addField("Location", coords, false).setFooter("Time of Incident: " + this.formatInstant(Instant.now()));
            this.sendDiscordMessage(embedBuilder.build());
        }
    }

    private String formatType(Entity entity) {
        String name = entity.getType().name().toLowerCase().replace("_", " ");
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private String formatInstant(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    private void sendDiscordMessage(MessageEmbed messageEmbed) {
        TextChannel channel;
        JDA discordBot = this.plugin.getDiscordBot();
        String channelID = this.config.getString("settings.discord-channel");
        if (discordBot != null && channelID != null && (channel = discordBot.getTextChannelById(channelID)) != null) {
            channel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue();
        }
    }
}

