/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.crafterscombatlogs.events;

import java.awt.Color;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import one.crafters.crafterscombatlogs.CraftersCombatLogs;
import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerCombatLogs
implements Listener {
    private static final String HEAD_URL = "https://mc-heads.net/avatar/";
    FileConfiguration config = CraftersCombatLogs.getInstance().getConfig();
    private final Map<Player, Long> pvpFightMessages = new HashMap<Player, Long>();

    @EventHandler
    public void onDamageOpponent(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player)) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if (e.getFinalDamage() <= 0.0) {
            return;
        }
        Player victim = (Player)e.getEntity();
        Player attacker = (Player)e.getDamager();
        if (this.isGodMode(attacker)) {
            return;
        }
        if (this.pvpFightMessages.containsKey(attacker) && System.currentTimeMillis() - this.pvpFightMessages.get(attacker) < 30000L) {
            this.editPreviousPvPFightMessage(attacker, victim, e.getFinalDamage());
        } else {
            this.createNewPvPFightMessage(attacker, victim, e.getFinalDamage());
        }
    }

    private boolean isGodMode(Player player) {
        return player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR;
    }

    private String formatInstant(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    private void createNewPvPFightMessage(Player attacker, Player victim, double damage) {
        String discordCombatMessage = this.config.getString("messages.discord-messages.player-combat-message");
        World world = attacker.getWorld();
        String worldName = world.getName();
        String formattedWorldName = worldName.equals("world_nether") ? "Nether" : (worldName.equals("world_the_end") ? "End" : "Overworld");
        int roundedDamage = (int)Math.round(damage);
        String damageString = Integer.toString(roundedDamage);
        ItemStack weaponItem = attacker.getInventory().getItemInMainHand();
        String weaponEnchants = this.getEnchantString(weaponItem);
        String weaponBlockName = this.getFormattedBlockName(weaponItem.getType());
        String weaponNickname = this.getWeaponNickname(weaponItem);
        if (weaponNickname.isEmpty()) {
            weaponNickname = "Unnamed";
        }
        String formattedMessage = discordCombatMessage.replace("{ATTACKER}", attacker.getName()).replace("{VICTIM}", victim.getName()).replace("{DAMAGE}", damageString).replace("{WORLD}", formattedWorldName).replace("{COORDS}", attacker.getLocation().getBlockX() + ", " + attacker.getLocation().getBlockY() + ", " + attacker.getLocation().getBlockZ()).replace("{WEAPON}", weaponBlockName).replace("{ENCHANTS}", weaponEnchants);
        EmbedBuilder embedBuilder = new EmbedBuilder();
        embedBuilder.setColor(Color.GRAY);
        embedBuilder.setAuthor("Crafter's Combat Logs | Damage Card", "https://wiki.crafters.one/wiki/Crafters_Combat_Logs", "https://crafters.one/img/craftersiconsmall.png");
        embedBuilder.setThumbnail(HEAD_URL + attacker.getUniqueId().toString() + ".png");
        embedBuilder.setDescription(formattedMessage);
        embedBuilder.addField("World", formattedWorldName, true);
        embedBuilder.addField("Coords", attacker.getLocation().getBlockX() + ", " + attacker.getLocation().getBlockY() + ", " + attacker.getLocation().getBlockZ(), true);
        embedBuilder.addField("Weapon", weaponBlockName.replace("Air", "Their Bare Fists :sunglasses:"), true);
        embedBuilder.addField("Weapon Nickname", weaponNickname, true);
        embedBuilder.addField("Enchants", weaponEnchants.isEmpty() ? "None" : weaponEnchants.replace("_", " "), true).setFooter("Time of Incident: " + this.formatInstant(Instant.now()));
        this.sendDiscordMessage(embedBuilder.build());
        this.pvpFightMessages.put(attacker, System.currentTimeMillis());
    }

    private void editPreviousPvPFightMessage(Player attacker, Player victim, double damage) {
        String previousMessageContent = this.getPreviousPvPFightMessageContent(attacker);
        if (previousMessageContent != null) {
            this.updatePreviousPvPFightMessage(attacker, previousMessageContent, victim, damage);
        } else {
            this.createNewPvPFightMessage(attacker, victim, damage);
        }
    }

    private String getPreviousPvPFightMessageContent(Player attacker) {
        HashMap previousMessageContents = new HashMap();
        return (String)previousMessageContents.get(attacker);
    }

    private void updatePreviousPvPFightMessage(Player attacker, String previousMessageContent, Player victim, double damage) {
        String[] parts = previousMessageContent.split("\\n");
        if (parts.length == 0) {
            return;
        }
        String lastAttackInfo = parts[parts.length - 1];
        String[] lastAttackParts = lastAttackInfo.split(" ");
        if (lastAttackParts.length != 5) {
            return;
        }
        String timestamp = lastAttackParts[0];
        String attackerName = lastAttackParts[1];
        String damageAmount = lastAttackParts[3];
        String victimName = lastAttackParts[4];
        String newAttackInfo = String.format("[%s] %s did %s damage to %s.", timestamp, attacker.getName(), (int)Math.round(damage), victim.getName());
        String updatedMessageContent = previousMessageContent.replace(lastAttackInfo, lastAttackInfo + "\n" + newAttackInfo);
        HashMap<Player, String> previousMessageContents = new HashMap<Player, String>();
        previousMessageContents.put(attacker, updatedMessageContent);
    }

    private String getEnchantString(ItemStack item) {
        ItemMeta itemMeta;
        Object enchantString = "";
        if (item != null && item.hasItemMeta() && (itemMeta = item.getItemMeta()).hasEnchants()) {
            for (Map.Entry entry : itemMeta.getEnchants().entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                enchantString = (String)enchantString + enchantment.getKey().getKey() + " " + level + ", ";
            }
            enchantString = ((String)enchantString).substring(0, ((String)enchantString).length() - 2);
        }
        return enchantString;
    }

    private String getFormattedBlockName(Material material) {
        return WordUtils.capitalizeFully(material.name().replace("_", " "));
    }

    private String getWeaponNickname(ItemStack item) {
        ItemMeta itemMeta;
        String weaponNickname = "";
        if (item != null && item.hasItemMeta() && (itemMeta = item.getItemMeta()).hasDisplayName()) {
            weaponNickname = itemMeta.getDisplayName();
        }
        return weaponNickname;
    }

    private void sendDiscordMessage(MessageEmbed messageEmbed) {
        TextChannel channel;
        CraftersCombatLogs plugin = CraftersCombatLogs.getInstance();
        JDA discordBot = plugin.getDiscordBot();
        FileConfiguration config = plugin.getConfig();
        String channelID = config.getString("settings.discord-channel");
        if (discordBot != null && channelID != null && (channel = discordBot.getTextChannelById(channelID)) != null) {
            channel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue();
        }
    }
}

