/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.crafterscombatlogs.events;

import java.awt.Color;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import one.crafters.crafterscombatlogs.CraftersCombatLogs;
import org.apache.commons.lang3.text.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class PlayerDeaths
implements Listener {
    private static final String HEAD_URL = "https://mc-heads.net/avatar/";
    FileConfiguration config = CraftersCombatLogs.getInstance().getConfig();

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        World world = victim.getWorld();
        String worldName = world.getName();
        String formattedWorldName = worldName.equals("world_nether") ? "Nether" : (worldName.equals("world_the_end") ? "End" : "Overworld");
        String deathMessage = event.getDeathMessage();
        EmbedBuilder embedBuilder = new EmbedBuilder();
        embedBuilder.setColor(Color.RED);
        embedBuilder.setAuthor(victim.getName(), HEAD_URL + victim.getUniqueId().toString(), HEAD_URL + victim.getUniqueId().toString());
        embedBuilder.setDescription(deathMessage);
        embedBuilder.addField("World", formattedWorldName, true);
        embedBuilder.addField("Coords", victim.getLocation().getBlockX() + ", " + victim.getLocation().getBlockY() + ", " + victim.getLocation().getBlockZ(), true);
        embedBuilder.addField("Ping / TPS", victim.getPing() + " ms / " + String.format("%.1f", Bukkit.getServer().getTPS()[0]), true);
        this.addInventoryContents(embedBuilder, (Inventory)victim.getInventory());
        this.sendDiscordMessage(embedBuilder.build(), event);
    }

    private void addInventoryContents(EmbedBuilder embedBuilder, Inventory inventory) {
        String itemName;
        HashMap<String, Integer> itemQuantities = new HashMap<String, Integer>();
        HashMap<String, Integer> shulkerContents = new HashMap<String, Integer>();
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            if (item.getType() == Material.SHULKER_BOX) {
                BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
                if (meta == null || !(meta.getBlockState() instanceof ShulkerBox)) continue;
                ShulkerBox shulkerBox = (ShulkerBox)meta.getBlockState();
                for (ItemStack content : shulkerBox.getInventory().getContents()) {
                    if (content == null || content.getType() == Material.AIR) continue;
                    String itemName2 = this.getFormattedBlockName(content.getType());
                    shulkerContents.put(itemName2, shulkerContents.getOrDefault(itemName2, 0) + content.getAmount());
                }
                continue;
            }
            String itemName3 = this.getFormattedBlockName(item.getType());
            itemQuantities.put(itemName3, itemQuantities.getOrDefault(itemName3, 0) + item.getAmount());
        }
        if (!itemQuantities.isEmpty()) {
            StringBuilder inventoryContentsBuilder = new StringBuilder();
            for (Map.Entry entry : itemQuantities.entrySet()) {
                itemName = (String)entry.getKey();
                int totalQuantity = (Integer)entry.getValue();
                inventoryContentsBuilder.append(itemName).append(": ").append(totalQuantity).append("\n");
            }
            embedBuilder.addField("Inventory Contents", inventoryContentsBuilder.toString().trim(), false);
        }
        if (!shulkerContents.isEmpty()) {
            StringBuilder shulkerContentsBuilder = new StringBuilder();
            for (Map.Entry entry : shulkerContents.entrySet()) {
                itemName = (String)entry.getKey();
                int totalQuantity = (Integer)entry.getValue();
                shulkerContentsBuilder.append(itemName).append(": ").append(totalQuantity).append("\n");
            }
            embedBuilder.addField("Shulker Box Contents", shulkerContentsBuilder.toString().trim(), false);
        }
    }

    private List<String> getItemEnchantments(ItemStack item) {
        ItemMeta itemMeta;
        ArrayList<String> enchantmentsList = new ArrayList<String>();
        if (item != null && item.hasItemMeta() && (itemMeta = item.getItemMeta()).hasEnchants()) {
            for (Map.Entry entry : itemMeta.getEnchants().entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                int level = (Integer)entry.getValue();
                String enchantmentString = enchantment.getKey().getKey() + " " + level;
                enchantmentsList.add(enchantmentString);
            }
        }
        return enchantmentsList;
    }

    private String getFormattedBlockName(Material material) {
        return WordUtils.capitalizeFully(material.name().replace("_", " "));
    }

    private String formatInstant(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    private void sendDiscordMessage(MessageEmbed messageEmbed, PlayerDeathEvent event) {
        CraftersCombatLogs plugin = CraftersCombatLogs.getInstance();
        JDA discordBot = plugin.getDiscordBot();
        FileConfiguration config = plugin.getConfig();
        String channelID = config.getString("settings.discord-channel");
        if (discordBot != null && channelID != null) {
            TextChannel channel = discordBot.getTextChannelById(channelID);
            if (channel != null) {
                EmbedBuilder embedBuilder = new EmbedBuilder().setColor(Color.RED).setAuthor("Crafter's Combat Logs | Death Card", "https://wiki.crafters.one/wiki/Crafters_Combat_Logs", "https://crafters.one/img/craftersiconsmall.png").addField("Player:", messageEmbed.getAuthor().getName(), true).addField("Cause of Death:", messageEmbed.getDescription(), false).setThumbnail(HEAD_URL + messageEmbed.getAuthor().getName() + ".png").setFooter("Time of Death: " + this.formatInstant(Instant.now()));
                for (MessageEmbed.Field field : messageEmbed.getFields()) {
                    embedBuilder.addField(field.getName(), field.getValue(), field.isInline());
                }
                channel.sendMessageEmbeds(embedBuilder.build(), new MessageEmbed[0]).queue();
            } else {
                plugin.getLogger().warning("The configured Discord channel ID is invalid.");
            }
        }
    }
}

