/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.crafterscombatlogs.events;

import java.awt.Color;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import one.crafters.crafterscombatlogs.CraftersCombatLogs;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class TotemPop
implements Listener {
    private static final String HEAD_URL = "https://mc-heads.net/avatar/";
    private FileConfiguration config = CraftersCombatLogs.getInstance().getConfig();

    public void onDeath(PlayerDeathEvent e) {
        Player p = e.getEntity();
    }

    private String formatInstant(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    @EventHandler
    public void totemPop(EntityResurrectEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getHand() != null) {
                EmbedBuilder embedBuilder = new EmbedBuilder();
                embedBuilder.setColor(Color.ORANGE);
                embedBuilder.setAuthor(player.getName() + " used a totem to escape death!", HEAD_URL + String.valueOf(player.getUniqueId()), HEAD_URL + String.valueOf(player.getUniqueId())).setFooter("Time of Incident: " + this.formatInstant(Instant.now()));
                this.sendDiscordMessage(embedBuilder.build());
            }
        }
    }

    private void sendDiscordMessage(MessageEmbed messageEmbed) {
        TextChannel channel;
        CraftersCombatLogs plugin = CraftersCombatLogs.getInstance();
        JDA discordBot = plugin.getDiscordBot();
        String channelID = this.config.getString("settings.discord-channel");
        if (discordBot != null && channelID != null && (channel = discordBot.getTextChannelById(channelID)) != null) {
            channel.sendMessageEmbeds(messageEmbed, new MessageEmbed[0]).queue();
        }
    }
}

