/*
 * Decompiled with CFR 0.152.
 */
package de.nexusrealms.eraofrails.entity.types;

import com.google.common.annotations.VisibleForTesting;
import de.nexusrealms.eraofrails.entity.ComparatorOutputtingMinecart;
import de.nexusrealms.eraofrails.item.RailwaysItems;
import de.nexusrealms.eraofrails.network.CartJukeboxSongPacket;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

public class JukeboxMinecartEntity
extends class_1688
implements ComparatorOutputtingMinecart {
    private class_1799 recordStack = class_1799.field_8037;
    private final CartJukeboxManager manager = new CartJukeboxManager();

    public JukeboxMinecartEntity(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
    }

    private CartJukeboxManager getManager() {
        return this.manager;
    }

    public class_2680 method_7517() {
        return class_2246.field_10223.method_9564();
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (hand == class_1268.field_5808) {
            class_1799 stack = player.method_5998(hand);
            boolean dropped = this.dropRecord();
            if (this.isValid(stack)) {
                this.setStack(stack);
                player.method_6122(hand, class_1799.field_8037);
                return class_1269.field_5812;
            }
            return dropped ? class_1269.field_5812 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void method_7516(class_3218 world, class_1282 damageSource) {
        super.method_7516(world, damageSource);
        this.dropRecord();
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.manager.stopPlaying();
    }

    public void method_5768(class_3218 world) {
        super.method_5768(world);
        this.manager.stopPlaying();
    }

    public void method_7506(int x, int y, int z, boolean powered) {
        if (powered) {
            this.dropRecord();
        }
    }

    public boolean dropRecord() {
        if (!this.method_37908().method_8608()) {
            class_2338 blockPos = this.method_24515();
            class_1799 itemStack = this.getRecordStack();
            if (!itemStack.method_7960()) {
                this.setStack(class_1799.field_8037);
                class_243 vec3d = class_243.method_49273((class_2382)blockPos, (double)0.5, (double)1.01, (double)0.5).method_49272(this.method_37908().method_8409(), 0.7f);
                class_1799 itemStack2 = itemStack.method_7972();
                class_1542 itemEntity = new class_1542(this.method_37908(), vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), itemStack2);
                itemEntity.method_6988();
                this.method_37908().method_8649((class_1297)itemEntity);
                return true;
            }
        }
        return false;
    }

    public void method_5773() {
        super.method_5773();
        this.manager.tick();
    }

    @Override
    public int getComparatorOutput() {
        return class_9793.method_60753((class_7225.class_7874)this.method_37908().method_30349(), (class_1799)this.recordStack).map(class_6880::comp_349).map(class_9793::comp_2838).orElse(0);
    }

    public void method_5651(class_11368 view) {
        super.method_5651(view);
        class_1799 itemStack = view.method_71426("recordItem", class_1799.field_24671).orElse(class_1799.field_8037);
        if (!this.recordStack.method_7960() && !class_1799.method_31577((class_1799)itemStack, (class_1799)this.recordStack)) {
            this.manager.stopPlaying();
        }
        this.recordStack = itemStack;
        view.method_71440("songTicks").ifPresent(ticksSinceSongStarted -> class_9793.method_60753((class_7225.class_7874)view.method_71414(), (class_1799)this.recordStack).ifPresent(song -> this.manager.setValues((class_6880<class_9793>)song, (long)ticksSinceSongStarted)));
    }

    public void method_5647(class_11372 view) {
        super.method_5647(view);
        if (!this.getRecordStack().method_7960()) {
            view.method_71468("recordItem", class_1799.field_24671, (Object)this.getRecordStack());
        }
        if (this.manager.getSong() != null) {
            view.method_71466("songTicks", this.manager.getTicksSinceSongStarted());
        }
    }

    public class_1799 getRecordStack() {
        return this.recordStack;
    }

    public void setStack(class_1799 stack) {
        this.recordStack = stack;
        boolean bl = !this.recordStack.method_7960();
        Optional optional = class_9793.method_60753((class_7225.class_7874)this.method_37908().method_30349(), (class_1799)this.recordStack);
        if (bl && optional.isPresent()) {
            this.manager.startPlaying((class_6880<class_9793>)((class_6880)optional.get()));
        } else {
            this.manager.stopPlaying();
        }
    }

    public boolean isValid(class_1799 stack) {
        return stack.method_57826(class_9334.field_52175) && this.getRecordStack().method_7960();
    }

    @VisibleForTesting
    public void setDisc(class_1799 stack) {
        this.recordStack = stack;
        class_9793.method_60753((class_7225.class_7874)this.method_37908().method_30349(), (class_1799)stack).ifPresent(song -> this.manager.setValues((class_6880<class_9793>)song, 0L));
    }

    @VisibleForTesting
    public void reloadDisc() {
        class_9793.method_60753((class_7225.class_7874)this.method_37908().method_30349(), (class_1799)this.getRecordStack()).ifPresent(this.manager::startPlaying);
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.method_7557());
    }

    protected class_1792 method_7557() {
        return RailwaysItems.JUKEBOX_MINECART;
    }

    private class CartJukeboxManager {
        public static final int TICKS_PER_SECOND = 20;
        private long songTicks;
        @Nullable
        private class_6880<class_9793> song;
        @Nullable
        private class_2338 startedPlayingPos;

        private CartJukeboxManager() {
        }

        public boolean isPlaying() {
            return this.song != null;
        }

        @Nullable
        public class_9793 getSong() {
            return this.song == null ? null : (class_9793)this.song.comp_349();
        }

        public long getTicksSinceSongStarted() {
            return this.songTicks;
        }

        public void setValues(class_6880<class_9793> song, long ticksPlaying) {
            if (!((class_9793)song.comp_349()).method_60751(ticksPlaying)) {
                this.song = song;
                this.songTicks = ticksPlaying;
            }
        }

        public void startPlaying(class_6880<class_9793> song) {
            this.song = song;
            this.startedPlayingPos = JukeboxMinecartEntity.super.method_24515();
            this.songTicks = 0L;
            int i = JukeboxMinecartEntity.super.method_56673().method_30530(class_7924.field_52176).method_10206((Object)((class_9793)this.song.comp_349()));
            if (!this.getWorld().method_8608()) {
                this.getWorld().method_8503().method_3760().method_14605(null, JukeboxMinecartEntity.this.method_23317(), JukeboxMinecartEntity.this.method_23318(), JukeboxMinecartEntity.this.method_23321(), 64.0, this.getWorld().method_27983(), (class_2596)new class_2658((class_8710)new CartJukeboxSongPacket(JukeboxMinecartEntity.this.method_5628(), i, false)));
            }
        }

        public void stopPlaying() {
            if (this.song != null) {
                this.song = null;
                this.songTicks = 0L;
                this.getWorld().method_43275((class_1297)JukeboxMinecartEntity.this, (class_6880)class_5712.field_39486, JukeboxMinecartEntity.this.method_19538());
                if (!this.getWorld().method_8608()) {
                    this.getWorld().method_8503().method_3760().method_14605(null, JukeboxMinecartEntity.this.method_23317(), JukeboxMinecartEntity.this.method_23318(), JukeboxMinecartEntity.this.method_23321(), 64.0, this.getWorld().method_27983(), (class_2596)new class_2658((class_8710)new CartJukeboxSongPacket(JukeboxMinecartEntity.this.method_5628(), 0, true)));
                }
            }
        }

        public void tick() {
            if (this.song != null) {
                if (((class_9793)this.song.comp_349()).method_60751(this.songTicks)) {
                    this.stopPlaying();
                } else {
                    if (this.hasSecondPassed()) {
                        this.getWorld().method_43275((class_1297)JukeboxMinecartEntity.this, (class_6880)class_5712.field_39485, JukeboxMinecartEntity.super.method_19538());
                        CartJukeboxManager.spawnNoteParticles((class_1936)this.getWorld(), JukeboxMinecartEntity.super.method_19538());
                    }
                    ++this.songTicks;
                }
            }
        }

        private class_1937 getWorld() {
            return JukeboxMinecartEntity.super.method_37908();
        }

        private boolean hasSecondPassed() {
            return this.songTicks % 20L == 0L;
        }

        private static void spawnNoteParticles(class_1936 world, class_243 pos) {
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_243 vec3d = pos.method_1031(0.0, (double)1.2f, 0.0);
                float f = (float)world.method_8409().method_43048(4) / 24.0f;
                serverWorld.method_65096((class_2394)class_2398.field_11224, vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), 0, (double)f, 0.0, 0.0, 1.0);
            }
        }
    }
}

