/*
 * Decompiled with CFR 0.152.
 */
package de.nexusrealms.eraofrails.client;

import de.nexusrealms.eraofrails.EraOfRails;
import de.nexusrealms.eraofrails.entity.types.InputMinecartEntity;
import de.nexusrealms.eraofrails.network.SetInputCartDataPacket;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class InputCartScreen
extends class_437 {
    private static final class_2960 BACKGROUND = EraOfRails.id("textures/gui/input_cart_screen_background.png");
    private static final class_2960 DISABLED = EraOfRails.id("textures/gui/input_switch_inactive.png");
    private static final class_2960 DISABLED_ON = EraOfRails.id("textures/gui/input_switch_inactive_on.png");
    private static final class_2960 SWITCH = EraOfRails.id("textures/gui/input_switch.png");
    private static final class_2960 SWITCH_ON = EraOfRails.id("textures/gui/input_switch_on.png");
    private static final class_2960 SWITCH_NEXT = EraOfRails.id("textures/gui/input_switch_next.png");
    private static final class_2960 SWITCH_ON_NEXT = EraOfRails.id("textures/gui/input_switch_on_next.png");
    private int originX;
    private int originY;
    private int switchOriginX;
    private int switchOriginY;
    private final InputMinecartEntity minecart;

    public InputCartScreen(InputMinecartEntity minecart) {
        super((class_2561)class_2561.method_43471((String)class_2246.field_10465.method_63499()));
        this.minecart = minecart;
    }

    protected void method_25426() {
        this.originX = this.field_22789 / 2 - 128;
        this.originY = this.field_22790 / 2 - 128;
        this.switchOriginX = this.originX + 24;
        this.switchOriginY = this.originY + 24;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25420(context, mouseX, mouseY, deltaTicks);
        context.method_25290(class_10799.field_56883, BACKGROUND, this.originX, this.originY, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        for (int i = 0; i < 64; ++i) {
            this.renderSwitch(context, i);
        }
    }

    public void renderSwitch(class_332 context, int i) {
        int x = this.switchOriginX + 26 * (i % 8);
        int y = this.switchOriginY + 26 * (i / 8);
        context.method_25290(class_10799.field_56883, this.getSwitchTexture(i), x, y, 0.0f, 0.0f, 26, 26, 26, 26);
    }

    private class_2960 getSwitchTexture(int i) {
        boolean isNext;
        boolean isActive;
        boolean isDisabled = i >= this.minecart.getActiveInsts();
        boolean bl = isActive = (this.minecart.getSequence() >> i & 1L) != 0L;
        if (isDisabled) {
            return isActive ? DISABLED_ON : DISABLED;
        }
        boolean bl2 = isNext = i == this.minecart.getNextInst();
        return isNext ? (isActive ? SWITCH_ON_NEXT : SWITCH_NEXT) : (isActive ? SWITCH_ON : SWITCH);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isWithinSwitchBounds(mouseX, mouseY)) {
            double xOffset = mouseX - (double)this.switchOriginX;
            double yOffset = mouseY - (double)this.switchOriginY;
            int switchX = (int)Math.floor(xOffset / 26.0);
            int switchY = (int)Math.floor(yOffset / 26.0);
            int i = 8 * switchY + switchX;
            if (button == 0) {
                long newSequence = this.minecart.getSequence() ^ 1L << i;
                ClientPlayNetworking.send((class_8710)new SetInputCartDataPacket(this.minecart.method_5628(), Optional.of(newSequence), Optional.empty()));
            } else if (button == 1) {
                int newActiveInsts = i + 1;
                ClientPlayNetworking.send((class_8710)new SetInputCartDataPacket(this.minecart.method_5628(), Optional.empty(), Optional.of(newActiveInsts)));
            }
            this.field_22787.field_1724.method_17356(class_3417.field_14962, class_3419.field_15248, 1.0f, 1.0f);
        }
        return false;
    }

    private boolean isWithinSwitchBounds(double x, double y) {
        return x > (double)this.switchOriginX && x < (double)(this.switchOriginX + 208) && y > (double)this.switchOriginY && y < (double)(this.switchOriginY + 208);
    }
}

