/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;

public interface GeoReplacedEntity
extends SingletonGeoAnimatable {
    public class_1299<?> getReplacingEntityType();

    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(class_1297 entity, SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(entity.method_5628()).getAnimatableData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(class_1297 relatedEntity, SerializableDataTicket<D> dataTicket, D data) {
        if (relatedEntity.method_73183().method_8608()) {
            this.getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628()).setAnimatableData(dataTicket, data);
        } else {
            GeckoLibServices.NETWORK.syncEntityAnimData(relatedEntity, true, dataTicket, data);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(class_1297 relatedEntity, @Nullable String controllerName, String animName) {
        if (relatedEntity.method_73183().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628());
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.tryTriggerAnimation(controllerName, animName);
            } else {
                animatableManager.tryTriggerAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.triggerEntityAnim(relatedEntity, true, controllerName, animName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(class_1297 relatedEntity, @Nullable String controllerName, @Nullable String animName) {
        if (relatedEntity.method_73183().method_8608()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(relatedEntity.method_5628());
            if (animatableManager == null) {
                return;
            }
            if (controllerName != null) {
                animatableManager.stopTriggeredAnimation(controllerName, animName);
            } else {
                animatableManager.stopTriggeredAnimation(animName);
            }
        } else {
            GeckoLibServices.NETWORK.stopTriggeredEntityAnim(relatedEntity, true, controllerName, animName);
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((class_1297)entity).field_6012;
    }

    @Override
    @ApiStatus.NonExtendable
    default public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
    }

    @Override
    @ApiStatus.NonExtendable
    default public Object getRenderProvider() {
        return null;
    }
}

