/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.constant;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationTest;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;

public final class DefaultAnimations {
    public static final RawAnimation ITEM_ON_USE = RawAnimation.begin().thenPlay("item.use");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    public static final RawAnimation IDLE_FLYING = RawAnimation.begin().thenLoop("misc.idle.flying");
    public static final RawAnimation LIVING = RawAnimation.begin().thenLoop("misc.living");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("misc.spawn");
    public static final RawAnimation DIE = RawAnimation.begin().thenPlay("misc.die");
    public static final RawAnimation INTERACT = RawAnimation.begin().thenPlay("misc.interact");
    public static final RawAnimation DEPLOY = RawAnimation.begin().thenPlay("misc.deploy");
    public static final RawAnimation REST = RawAnimation.begin().thenPlay("misc.rest");
    public static final RawAnimation SIT = RawAnimation.begin().thenPlayAndHold("misc.sit");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    public static final RawAnimation SWIM = RawAnimation.begin().thenLoop("move.swim");
    public static final RawAnimation RUN = RawAnimation.begin().thenLoop("move.run");
    public static final RawAnimation DRIVE = RawAnimation.begin().thenLoop("move.drive");
    public static final RawAnimation FLY = RawAnimation.begin().thenLoop("move.fly");
    public static final RawAnimation CRAWL = RawAnimation.begin().thenLoop("move.crawl");
    public static final RawAnimation JUMP = RawAnimation.begin().thenPlay("move.jump");
    public static final RawAnimation SNEAK = RawAnimation.begin().thenLoop("move.sneak");
    public static final RawAnimation DIVE = RawAnimation.begin().thenPlayAndHold("move.dive");
    public static final RawAnimation ATTACK_CAST = RawAnimation.begin().thenPlay("attack.cast");
    public static final RawAnimation ATTACK_SWING = RawAnimation.begin().thenPlay("attack.swing");
    public static final RawAnimation ATTACK_THROW = RawAnimation.begin().thenPlay("attack.throw");
    public static final RawAnimation ATTACK_PUNCH = RawAnimation.begin().thenPlay("attack.punch");
    public static final RawAnimation ATTACK_BITE = RawAnimation.begin().thenPlay("attack.bite");
    public static final RawAnimation ATTACK_SLAM = RawAnimation.begin().thenPlay("attack.slam");
    public static final RawAnimation ATTACK_STOMP = RawAnimation.begin().thenPlay("attack.stomp");
    public static final RawAnimation ATTACK_STRIKE = RawAnimation.begin().thenPlay("attack.strike");
    public static final RawAnimation ATTACK_FLYING_ATTACK = RawAnimation.begin().thenPlay("attack.flying_attack");
    public static final RawAnimation ATTACK_SHOOT = RawAnimation.begin().thenPlay("attack.shoot");
    public static final RawAnimation ATTACK_BLOCK = RawAnimation.begin().thenPlay("attack.block");
    public static final RawAnimation ATTACK_CHARGE = RawAnimation.begin().thenPlay("attack.charge");
    public static final RawAnimation ATTACK_CHARGE_END = RawAnimation.begin().thenPlay("attack.charge_end");
    public static final RawAnimation ATTACK_POWERUP = RawAnimation.begin().thenPlay("attack.powerup");

    public static <T extends GeoAnimatable> AnimationController<T> triggerOnlyController() {
        return new AnimationController("Actions", test -> PlayState.STOP);
    }

    public static <T extends GeoAnimatable> AnimationController<T> basicPredicateController(Function<AnimationTest<T>, @Nullable RawAnimation> predicate) {
        return new AnimationController("Generic", test -> {
            RawAnimation result = (RawAnimation)predicate.apply(test);
            return result == null ? PlayState.STOP : test.setAndContinue(result);
        });
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericLivingController() {
        return new AnimationController("Living", test -> test.setAndContinue(LIVING));
    }

    public static <T extends class_1309> AnimationController<T> genericDeathController() {
        return new AnimationController("Death", test -> test.getDataOrDefault(DataTickets.IS_DEAD_OR_DYING, false) != false ? test.setAndContinue(DIE) : PlayState.STOP);
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericIdleController() {
        return new AnimationController("Idle", test -> test.setAndContinue(IDLE));
    }

    public static <T extends GeoAnimatable> AnimationController<T> getSpawnController(int spawnTicks) {
        return new AnimationController("Spawn", test -> test.getData(DataTickets.TICK) <= (double)spawnTicks ? test.setAndContinue(SPAWN) : PlayState.STOP);
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericWalkController() {
        return new AnimationController("Walk", test -> test.isMoving() ? test.setAndContinue(WALK) : PlayState.STOP);
    }

    public static <T extends class_1309> AnimationController<T> genericAttackAnimation(RawAnimation attackAnimation) {
        return new AnimationController("Attack", test -> {
            if (test.getDataOrDefault(DataTickets.SWINGING_ARM, false).booleanValue()) {
                return test.setAndContinue(attackAnimation);
            }
            test.controller().forceAnimationReset();
            return PlayState.STOP;
        });
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericWalkIdleController() {
        return new AnimationController("Walk/Idle", test -> test.setAndContinue(test.isMoving() ? WALK : IDLE));
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericSwimController() {
        return new AnimationController("Swim", test -> test.isMoving() ? test.setAndContinue(SWIM) : PlayState.STOP);
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericSwimIdleController() {
        return new AnimationController("Swim/Idle", test -> test.setAndContinue(test.isMoving() ? SWIM : IDLE));
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericFlyController() {
        return new AnimationController("Fly", test -> test.isMoving() ? test.setAndContinue(FLY) : PlayState.STOP);
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericFlyIdleController() {
        return new AnimationController("Fly/Idle", test -> test.setAndContinue(test.isMoving() ? FLY : IDLE));
    }

    public static <T extends GeoAnimatable> AnimationController<T> genericWalkFlyIdleController(class_1308 entity) {
        return new AnimationController("Walk/Fly/Idle", 0, state -> {
            if (entity.method_24828() || !entity.method_5987() && (double)(entity.method_23314().method_10264() + 1) == entity.method_23318()) {
                return state.setAndContinue(state.isMoving() ? WALK : IDLE);
            }
            return state.setAndContinue(state.isMoving() ? FLY : IDLE_FLYING);
        });
    }

    public static <T extends class_1297> AnimationController<T> genericWalkRunIdleController() {
        return new AnimationController("Walk/Run/Idle", test -> {
            if (test.isMoving()) {
                return test.setAndContinue(test.getDataOrDefault(DataTickets.SPRINTING, false) != false ? RUN : WALK);
            }
            return test.setAndContinue(IDLE);
        });
    }
}

