/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math.function;

import java.util.Set;
import java.util.StringJoiner;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.value.Variable;

public abstract class MathFunction
implements MathValue {
    private final boolean isMutable;
    private final Set<Variable> usedVariables;
    private double cachedValue = Double.MIN_VALUE;

    protected MathFunction(MathValue ... values) {
        this.validate(values);
        this.isMutable = this.isMutable(values);
        this.usedVariables = MathValue.collectUsedVariables(values);
    }

    public abstract String getName();

    @Override
    public final double get(AnimationState<?> animationState) {
        if (this.isMutable) {
            return this.compute(animationState);
        }
        if (this.cachedValue == Double.MIN_VALUE) {
            this.cachedValue = this.compute(animationState);
        }
        return this.cachedValue;
    }

    public abstract double compute(AnimationState<?> var1);

    public boolean isMutable(MathValue ... values) {
        for (MathValue value : values) {
            if (!value.isMutable()) continue;
            return true;
        }
        return false;
    }

    public abstract int getMinArgs();

    public abstract MathValue[] getArgs();

    public void validate(MathValue ... inputs) throws IllegalArgumentException {
        int minArgs = this.getMinArgs();
        if (inputs.length < minArgs) {
            throw new IllegalArgumentException(String.format("Function '%s' at least %s arguments. Only %s given!", this.getName(), minArgs, inputs.length));
        }
    }

    @Override
    public final boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public Set<Variable> getUsedVariables() {
        return this.usedVariables;
    }

    public String toString() {
        MathValue[] args = this.getArgs();
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (MathValue arg : args) {
            joiner.add(arg.toString());
        }
        return this.getName() + String.valueOf(joiner);
    }

    @FunctionalInterface
    public static interface Factory<T extends MathFunction> {
        public T create(MathValue ... var1);
    }
}

