/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10192;
import net.minecraft.class_11659;
import net.minecraft.class_11785;
import net.minecraft.class_12075;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import net.minecraft.class_970;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.RenderModelPositioner;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoArmorRenderer<T extends class_1792, R extends class_10034>
implements GeoRenderer<T, RenderData, R> {
    protected static final class_1304[] ARMOR_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    protected final GeoRenderLayersContainer<T, RenderData, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public <I extends T> GeoArmorRenderer(I armorItem) {
        this(new DefaultedGeoModel<T>(class_7923.field_41178.method_10221(armorItem)){

            @Override
            protected String subtype() {
                return "armor";
            }
        });
    }

    public GeoArmorRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, RenderData, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T, R> withRenderLayer(Function<? super GeoArmorRenderer<T, R>, GeoRenderLayer<T, RenderData, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoArmorRenderer<T, R> withRenderLayer(GeoRenderLayer<T, RenderData, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public int getRenderColor(T animatable, RenderData stackAndSlot, float partialTick) {
        return GeckoLibServices.Client.ITEM_RENDERING.getDyedItemColor(stackAndSlot.itemStack(), -1);
    }

    @Override
    @Nullable
    public class_1921 getRenderType(R renderState, class_2960 texture) {
        return class_1921.method_25448((class_2960)texture);
    }

    public List<ArmorSegment> getSegmentsForSlot(R renderState, class_1304 slot) {
        return switch (slot) {
            case class_1304.field_6169 -> List.of(ArmorSegment.HEAD);
            case class_1304.field_6174 -> List.of(ArmorSegment.CHEST, ArmorSegment.LEFT_ARM, ArmorSegment.RIGHT_ARM);
            case class_1304.field_6172 -> List.of(ArmorSegment.LEFT_LEG, ArmorSegment.RIGHT_LEG);
            case class_1304.field_6166 -> List.of(ArmorSegment.LEFT_FOOT, ArmorSegment.RIGHT_FOOT);
            default -> List.of();
        };
    }

    public String getBoneNameForSegment(R renderState, ArmorSegment segment) {
        return switch (segment.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "armorHead";
            case 1 -> "armorBody";
            case 2 -> "armorLeftArm";
            case 3 -> "armorRightArm";
            case 4 -> "armorLeftLeg";
            case 5 -> "armorRightLeg";
            case 6 -> "armorLeftBoot";
            case 7 -> "armorRightBoot";
        };
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, RenderData renderData, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, renderData, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GECKOLIB_WEARER, renderData.entity() instanceof GeoAnimatable);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_SLOT, renderData.slot());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.HAS_GLINT, renderData.itemStack().method_7958());
        v0 = (GeoRenderState)renderState;
        if (!(renderState instanceof class_10042)) ** GOTO lbl-1000
        livingRenderState = renderState;
        if (livingRenderState.field_53461) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v0.addGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, v1);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.HUMANOID_MODEL, renderData.baseModel);
        return renderState;
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, cameraState);
    }

    @Override
    public void adjustRenderPose(R renderState, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        poseStack.method_46416(0.0f, 1.5f, 0.0f);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
    }

    @Override
    public void buildRenderTask(R renderState, class_4587 poseStack, BakedGeoModel bakedModel, GeoModel<T> model, class_11785 renderTasks, class_12075 cameraState, @Nullable class_1921 renderType, int packedLight, int packedOverlay, int renderColor, @Nullable RenderModelPositioner<R> modelPositioner) {
        if (renderType == null) {
            return;
        }
        RenderModelPositioner<class_10034> callback = RenderModelPositioner.add(modelPositioner, (renderState2, model2) -> model.handleAnimations(this.createAnimationState(renderState2)));
        renderTasks.method_73483(poseStack, renderType, (pose, vertexConsumer) -> {
            class_1304 slot = ((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_SLOT);
            class_4587 poseStack2 = new class_4587();
            class_572 baseModel = ((GeoRenderState)renderState).getGeckolibData(DataTickets.HUMANOID_MODEL);
            poseStack2.method_23760().method_66521(pose);
            callback.run((class_10034)renderState, bakedModel);
            for (ArmorSegment segment : this.getSegmentsForSlot(renderState, slot)) {
                bakedModel.getBone(this.getBoneNameForSegment(renderState, segment)).ifPresent(bone -> {
                    class_630 modelPart = segment.modelPartGetter.apply(baseModel);
                    Vector3f bonePos = (Vector3f)segment.modelPartMatcher.apply(new Vector3f(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655));
                    baseModel.method_17087(renderState);
                    RenderUtil.matchModelPartRot(modelPart, bone);
                    bone.updatePosition(bonePos.x, bonePos.y, bonePos.z);
                    this.renderBone(renderState, poseStack2, (GeoBone)bone, vertexConsumer, cameraState, packedLight, packedOverlay, renderColor);
                });
            }
        });
    }

    @Override
    public void renderBone(R renderState, class_4587 poseStack, GeoBone bone, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.OBJECT_RENDER_POSE)));
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.MODEL_RENDER_POSE)));
        }
        GeoRenderer.super.renderBone(renderState, poseStack, bone, buffer, cameraState, packedLight, packedOverlay, renderColor);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, RenderData relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        return GeckoLibServices.Client.EVENTS.fireArmorPreRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    public void firePostRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        GeckoLibServices.Client.EVENTS.fireArmorPostRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, RenderData stackAndSlot) {
        long stackId = GeoItem.getId(stackAndSlot.itemStack());
        if (stackId == Long.MAX_VALUE) {
            int id = stackAndSlot.entity().method_5628() * 13;
            return (long)id * (long)id * (long)id * (long)(-(stackAndSlot.slot().ordinal() + 1));
        }
        return -stackId;
    }

    @ApiStatus.Internal
    public static <R extends class_10034, A extends class_572<R>> boolean tryRenderGeoArmorPiece(BiFunction<R, class_1304, A> modelFunction, class_4587 poseStack, class_11659 renderTasks, class_1799 stack, class_1304 slot, int packedLight, R entityRenderState) {
        StackForRender stackForRender = StackForRender.find(stack, slot, entityRenderState, modelFunction);
        if (stackForRender == null || !(entityRenderState instanceof GeoRenderState)) {
            return false;
        }
        R geoRenderState = entityRenderState;
        EnumMap perSlotData = geoRenderState.getOrDefaultGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, null);
        if (perSlotData == null || !perSlotData.containsKey(slot)) {
            return false;
        }
        class_10034 perSlotRenderState = (class_10034)perSlotData.get(slot);
        stackForRender.renderer.submitRenderTasks((GeoRenderState)perSlotRenderState, poseStack, renderTasks, class_310.method_1551().field_1769.field_61737.field_63082, null);
        return true;
    }

    @ApiStatus.Internal
    public static <R extends class_10034, A extends class_572<R>> void captureRenderStates(R baseRenderState, class_1309 entity, float partialTick, BiFunction<R, class_1304, A> modelFunction, Function<class_1304, R> renderStateSupplier) {
        List<StackForRender> relevantSlots = GeoArmorRenderer.getRelevantSlotsForRendering(entity, baseRenderState, modelFunction);
        if (relevantSlots == null) {
            return;
        }
        EnumMap<class_1304, class_10034> slotRenderData = new EnumMap<class_1304, class_10034>(class_1304.class);
        for (StackForRender entry : relevantSlots) {
            RenderData renderData = new RenderData(entry.stack, entry.slot, entity, entry.baseModel);
            class_10034 slotRenderState = (class_10034)renderStateSupplier.apply(entry.slot);
            entry.renderer.fillRenderState((GeoAnimatable)entry.stack.method_7909(), renderData, (GeoRenderState)slotRenderState, partialTick);
            slotRenderData.put(entry.slot, slotRenderState);
        }
        ((GeoRenderState)baseRenderState).addGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, slotRenderData);
    }

    @Nullable
    @ApiStatus.Internal
    private static <R extends class_10034, A extends class_572<R>> List<StackForRender> getRelevantSlotsForRendering(class_1309 entity, R entityRenderState, BiFunction<R, class_1304, A> modelFunction) {
        List relevantSlots = null;
        for (int i = 0; i < ARMOR_SLOTS.length; ++i) {
            class_1304 slot = ARMOR_SLOTS[i];
            StackForRender stackForRender = StackForRender.find(entity.method_6118(slot), slot, entityRenderState, modelFunction);
            if (stackForRender == null) continue;
            if (relevantSlots == null) {
                relevantSlots = new ObjectArrayList(ARMOR_SLOTS.length - i);
            }
            relevantSlots.add(stackForRender);
        }
        return relevantSlots;
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public R createRenderState(T animatable, RenderData relatedObject) {
        return (R)new class_10034();
    }

    public record RenderData(class_1799 itemStack, class_1304 slot, class_1309 entity, class_572<?> baseModel) {
    }

    public static enum ArmorSegment {
        HEAD(class_1304.field_6169, model -> model.field_3398, pos -> pos.mul(1.0f, -1.0f, 1.0f)),
        CHEST(class_1304.field_6174, model -> model.field_3391, pos -> pos.mul(1.0f, -1.0f, 1.0f)),
        LEFT_ARM(class_1304.field_6174, model -> model.field_27433, pos -> pos.set(pos.x - 5.0f, 2.0f - pos.y, pos.z)),
        RIGHT_ARM(class_1304.field_6174, model -> model.field_3401, pos -> pos.set(pos.x + 5.0f, 2.0f - pos.y, pos.z)),
        LEFT_LEG(class_1304.field_6172, model -> model.field_3397, pos -> pos.set(pos.x - 2.0f, 12.0f - pos.y, pos.z)),
        RIGHT_LEG(class_1304.field_6172, model -> model.field_3392, pos -> pos.set(pos.x + 2.0f, 12.0f - pos.y, pos.z)),
        LEFT_FOOT(class_1304.field_6166, model -> model.field_3397, pos -> pos.set(pos.x - 2.0f, 12.0f - pos.y, pos.z)),
        RIGHT_FOOT(class_1304.field_6166, model -> model.field_3392, pos -> pos.set(pos.x + 2.0f, 12.0f - pos.y, pos.z));

        public final class_1304 equipmentSlot;
        public final Function<class_572<?>, class_630> modelPartGetter;
        public final UnaryOperator<Vector3f> modelPartMatcher;

        private ArmorSegment(class_1304 slot, Function<class_572<?>, class_630> modelPartGetter, UnaryOperator<Vector3f> modelPartMatcher) {
            this.equipmentSlot = slot;
            this.modelPartGetter = modelPartGetter;
            this.modelPartMatcher = modelPartMatcher;
        }
    }

    @ApiStatus.Internal
    private record StackForRender(class_1799 stack, class_1304 slot, GeoArmorRenderer renderer, class_572<?> baseModel) {
        @Nullable
        private static <S extends class_10034, A extends class_572<S>> StackForRender find(class_1799 stack, class_1304 slot, S entityRenderState, BiFunction<S, class_1304, A> modelFunction) {
            GeoRenderProvider geckolibRenderers;
            class_10192 equippable = (class_10192)stack.method_58694(class_9334.field_54196);
            if (equippable == null || !class_970.method_64082((class_10192)equippable, (class_1304)slot) || (geckolibRenderers = GeoRenderProvider.of(stack)) == GeoRenderProvider.DEFAULT) {
                return null;
            }
            class_572 baseModel = (class_572)modelFunction.apply(entityRenderState, slot);
            GeoArmorRenderer<?, ?> armorRenderer = geckolibRenderers.getGeoArmorRenderer(stack, slot);
            if (armorRenderer == null) {
                return null;
            }
            return new StackForRender(stack, slot, armorRenderer, baseModel);
        }
    }
}

