/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import java.util.List;
import java.util.Map;
import net.minecraft.class_11659;
import net.minecraft.class_11785;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.base.PerBoneRenderTasks;
import software.bernie.geckolib.renderer.base.RenderModelPositioner;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public interface GeoRenderer<T extends GeoAnimatable, O, R extends GeoRenderState> {
    public GeoModel<T> getGeoModel();

    default public List<GeoRenderLayer<T, O, R>> getRenderLayers() {
        return List.of();
    }

    @ApiStatus.Internal
    default public long getInstanceId(T animatable, O relatedObject) {
        return animatable.hashCode();
    }

    default public int getRenderColor(T animatable, O relatedObject, float partialTick) {
        return -1;
    }

    default public int getPackedOverlay(T animatable, O relatedObject, float u, float partialTick) {
        return class_4608.field_21444;
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public class_2960 getTextureLocation(R renderState) {
        return this.getGeoModel().getTextureResource((GeoRenderState)renderState);
    }

    @Nullable
    default public class_1921 getRenderType(R renderState, class_2960 texture) {
        return this.getGeoModel().getRenderType((GeoRenderState)renderState, texture);
    }

    @ApiStatus.OverrideOnly
    default public void addRenderData(T animatable, O relatedObject, R renderState, float partialTick) {
    }

    @ApiStatus.Internal
    default public R captureDefaultRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        long instanceId = this.getInstanceId(animatable, relatedObject);
        renderState.addGeckolibData(DataTickets.TICK, animatable.getTick(relatedObject));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, instanceId);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, animatable.getAnimatableInstanceCache().getManagerForId(instanceId));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, (Float)Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, this.getRenderColor(animatable, relatedObject, partialTick));
        renderState.addGeckolibData(DataTickets.PACKED_OVERLAY, this.getPackedOverlay(animatable, relatedObject, 0.0f, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, false);
        renderState.addGeckolibData(DataTickets.BONE_RESET_TIME, animatable.getBoneResetTime());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, animatable.getClass());
        renderState.addGeckolibData(DataTickets.PER_BONE_TASKS, (PerBoneRenderTasks)PerBoneRenderTasks.create());
        return renderState;
    }

    public R createRenderState(T var1, O var2);

    @ApiStatus.Internal
    default public R fillRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        this.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        this.addRenderData(animatable, relatedObject, renderState, partialTick);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.addRenderData(animatable, relatedObject, renderState, partialTick);
        }
        this.fireCompileRenderStateEvent(animatable, relatedObject, renderState, partialTick);
        this.getGeoModel().prepareForRenderPass(animatable, (GeoRenderState)renderState, partialTick);
        return renderState;
    }

    default public void submitRenderTasks(R renderState, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraState, @Nullable RenderModelPositioner<R> modelPositioner) {
        poseStack.method_22903();
        GeoModel<T> geoModel = this.getGeoModel();
        BakedGeoModel model = geoModel.getBakedModel(geoModel.getModelResource((GeoRenderState)renderState));
        int packedLight = renderState.getPackedLight();
        int packedOverlay = renderState.getGeckolibData(DataTickets.PACKED_OVERLAY);
        int renderColor = renderState.getGeckolibData(DataTickets.RENDER_COLOR);
        class_1921 renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        renderState.addGeckolibData(DataTickets.OBJECT_RENDER_POSE, (Matrix4f)new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761()));
        if (this.firePreRenderEvent(renderState, poseStack, model, renderTasks, cameraState)) {
            this.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
            this.scaleModelForRender(renderState, 1.0f, 1.0f, poseStack, model, cameraState);
            this.adjustRenderPose(renderState, poseStack, model, cameraState);
            this.preApplyRenderLayers(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor, renderType != null);
            renderState.addGeckolibData(DataTickets.MODEL_RENDER_POSE, (Matrix4f)new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761()));
            this.buildRenderTask(renderState, poseStack, model, geoModel, (class_11785)renderTasks, cameraState, renderType, packedLight, packedOverlay, renderColor, modelPositioner);
            this.applyRenderLayers(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor, renderType != null);
            this.postRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
            this.firePostRenderEvent(renderState, poseStack, model, renderTasks, cameraState);
        }
        poseStack.method_22909();
        this.renderFinal(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
    }

    default public void buildRenderTask(R renderState, class_4587 poseStack, BakedGeoModel bakedModel, GeoModel<T> model, class_11785 renderTasks, class_12075 cameraState, @Nullable class_1921 renderType, int packedLight, int packedOverlay, int renderColor, @Nullable RenderModelPositioner<R> modelPositioner) {
        if (renderType == null) {
            return;
        }
        RenderModelPositioner<GeoRenderState> callback = RenderModelPositioner.add(modelPositioner, (renderState2, model2) -> model.handleAnimations(this.createAnimationState(renderState2)));
        renderTasks.method_73483(poseStack, renderType, (pose, vertexConsumer) -> {
            class_4587 poseStack2 = new class_4587();
            poseStack2.method_23760().method_66521(pose);
            callback.run((GeoRenderState)renderState, bakedModel);
            for (GeoBone bone : bakedModel.topLevelBones()) {
                this.renderBone(renderState, poseStack2, bone, vertexConsumer, cameraState, packedLight, packedOverlay, renderColor);
            }
        });
    }

    default public void preApplyRenderLayers(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor, boolean didRenderModel) {
        PerBoneRenderTasks.ForRenderer<R> perBoneTasks = this.getPerBoneTasks(renderState);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor, didRenderModel);
            renderLayer.addPerBoneRender(renderState, model, didRenderModel, perBoneTasks::addTask);
        }
    }

    default public void applyRenderLayers(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor, boolean didRenderModel) {
        PerBoneRenderTasks.ForRenderer<R> perBoneTasks = this.getPerBoneTasks(renderState);
        if (!perBoneTasks.isEmpty()) {
            this.submitPerBoneRenderTasks(renderState, poseStack, perBoneTasks, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
        }
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.submitRenderTask(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor, didRenderModel);
        }
    }

    default public void submitPerBoneRenderTasks(R renderState, class_4587 poseStack, PerBoneRenderTasks.ForRenderer<R> perBoneTasks, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        Matrix4f pose = renderState.getGeckolibData(DataTickets.MODEL_RENDER_POSE);
        poseStack.method_22903();
        poseStack.method_23760().method_23761().set((Matrix4fc)pose);
        for (Map.Entry<GeoBone, List<PerBoneRender<R>>> boneTasks : perBoneTasks) {
            poseStack.method_22903();
            boneTasks.getKey().transformToBone(poseStack);
            for (PerBoneRender<R> renderOp : boneTasks.getValue()) {
                poseStack.method_22903();
                renderOp.submitRenderTask(renderState, poseStack, boneTasks.getKey(), renderTasks, cameraState, packedLight, packedOverlay, renderColor);
                poseStack.method_22909();
            }
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    default public void preRender(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void postRender(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void renderFinal(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
    }

    default public void renderBone(R renderState, class_4587 poseStack, GeoBone bone, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        poseStack.method_22903();
        RenderUtil.prepMatrixForBone(poseStack, bone);
        this.renderCubesOfBone(renderState, bone, poseStack, buffer, cameraState, packedLight, packedOverlay, renderColor);
        this.renderChildBones(renderState, bone, poseStack, buffer, cameraState, packedLight, packedOverlay, renderColor);
        poseStack.method_22909();
    }

    default public void renderCubesOfBone(R renderState, GeoBone bone, class_4587 poseStack, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isHidden()) {
            return;
        }
        for (GeoCube cube : bone.getCubes()) {
            poseStack.method_22903();
            this.renderCube(renderState, cube, poseStack, buffer, cameraState, packedLight, packedOverlay, renderColor);
            poseStack.method_22909();
        }
    }

    default public void renderChildBones(R renderState, GeoBone bone, class_4587 poseStack, class_4588 buffer, class_12075 cameraState, int packedLight, int packedColor, int renderColor) {
        if (bone.isHidingChildren()) {
            return;
        }
        for (GeoBone childBone : bone.getChildBones()) {
            this.renderBone(renderState, poseStack, childBone, buffer, cameraState, packedLight, packedColor, renderColor);
        }
    }

    default public void renderCube(R renderState, GeoCube cube, class_4587 poseStack, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        RenderUtil.translateToPivotPoint(poseStack, cube);
        RenderUtil.rotateMatrixAroundCube(poseStack, cube);
        RenderUtil.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.method_23760().method_23762();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(renderState, quad, poseState, normal, buffer, packedOverlay, packedLight, renderColor);
        }
    }

    default public void createVerticesOfQuad(R renderState, GeoQuad quad, Matrix4f poseState, Vector3f normal, class_4588 buffer, int packedOverlay, int packedLight, int renderColor) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU(), vertex.texV(), packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    default public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        if (widthScale != 1.0f || heightScale != 1.0f) {
            poseStack.method_22905(widthScale, heightScale, widthScale);
        }
    }

    default public void adjustRenderPose(R renderState, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
    }

    default public AnimationState<T> createAnimationState(R renderState) {
        return new AnimationState((GeoRenderState)renderState);
    }

    default public void setBonesVisible(boolean visible, String ... boneNames) {
        GeoModel<T> model = this.getGeoModel();
        for (String boneName : boneNames) {
            model.getBone(boneName).ifPresent(bone -> bone.setHidden(!visible));
        }
    }

    default public void setBonesVisible(boolean visible, GeoBone ... bones) {
        if (bones == null) {
            return;
        }
        for (GeoBone bone : bones) {
            if (bone == null) continue;
            bone.setHidden(!visible);
        }
    }

    public void fireCompileRenderLayersEvent();

    public void fireCompileRenderStateEvent(T var1, O var2, R var3, float var4);

    public boolean firePreRenderEvent(R var1, class_4587 var2, BakedGeoModel var3, class_11659 var4, class_12075 var5);

    public void firePostRenderEvent(R var1, class_4587 var2, BakedGeoModel var3, class_11659 var4, class_12075 var5);

    default public PerBoneRenderTasks.ForRenderer<R> getPerBoneTasks(R renderState) {
        return PerBoneRenderTasks.get(renderState, this);
    }
}

