/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public final class RenderModelPositioner<R extends GeoRenderState> {
    private final List<Callback<R>> callbacks;

    private RenderModelPositioner(List<Callback<R>> callbacks) {
        this.callbacks = callbacks;
    }

    public void run(R renderState, BakedGeoModel model) {
        for (Callback<R> callback : this.callbacks) {
            callback.run(renderState, model);
        }
    }

    public static <R extends GeoRenderState> RenderModelPositioner<R> add(@Nullable RenderModelPositioner<R> existing, Callback<R> callback) {
        if (existing == null) {
            existing = new RenderModelPositioner<R>(new ObjectArrayList(1));
        }
        existing.callbacks.add(callback);
        return existing;
    }

    @FunctionalInterface
    public static interface Callback<R extends GeoRenderState> {
        public void run(R var1, BakedGeoModel var2);
    }
}

