/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.textures.GpuTexture;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public final class RenderUtil {
    public static void translateMatrixToBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(class_4587 poseStack, GeoBone bone) {
        if (bone.getRotZ() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(bone.getRotZ()));
        }
        if (bone.getRotY() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(bone.getRotY()));
        }
        if (bone.getRotX() != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(bone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(class_4587 poseStack, GeoCube cube) {
        class_243 rotation = cube.rotation();
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.method_10215()));
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)rotation.method_10214(), 0.0f));
        poseStack.method_22907((Quaternionfc)new Quaternionf().rotationXYZ((float)rotation.method_10216(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(class_4587 poseStack, GeoBone bone) {
        poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoBone bone) {
        poseStack.method_46416(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(class_4587 poseStack, GeoBone bone) {
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    public static IntIntPair getTextureDimensions(class_2960 texture) {
        GpuTexture gpuTexture = class_310.method_1551().method_1531().method_4619(texture).method_68004();
        return IntIntPair.of((int)gpuTexture.getWidth(0), (int)gpuTexture.getHeight(0));
    }

    public static void matchModelPartRot(class_630 from, GeoBone to) {
        to.updateRotation(-from.field_3654, -from.field_3675, from.field_3674);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }

    public static double lerpYaw(double delta, double start, double end) {
        double diff = (start = class_3532.method_15338((double)start)) - (end = class_3532.method_15338((double)end));
        end = diff > 180.0 || diff < -180.0 ? start + Math.copySign(360.0 - Math.abs(diff), diff) : end;
        return class_3532.method_16436((double)delta, (double)start, (double)end);
    }

    public static class_2960 getEmissiveResource(class_2960 textureLocation) {
        return textureLocation.method_45134(path -> path.replace(".png", "_glowmask.png"));
    }

    @Nullable
    public static GeoReplacedEntityRenderer<?, ?, ?> getReplacedEntityRenderer(class_1299<?> entityType) {
        GeoReplacedEntityRenderer replacedEntityRenderer;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        return v instanceof GeoReplacedEntityRenderer ? (replacedEntityRenderer = (GeoReplacedEntityRenderer)v) : null;
    }

    @Nullable
    public static GeoItemRenderer<?> getGeckoLibItemRenderer(class_1792 item) {
        return GeoRenderProvider.of(item).getGeoItemRenderer();
    }

    @Nullable
    public static GeoEntityRenderer<?, ?> getGeckoLibEntityRenderer(class_1299<?> entityType) {
        GeoEntityRenderer geoEntityRenderer;
        Object v = class_310.method_1551().method_1561().field_4696.get(entityType);
        return v instanceof GeoEntityRenderer ? (geoEntityRenderer = (GeoEntityRenderer)v) : null;
    }

    @Nullable
    public static GeoBlockRenderer<?, ?> getGeckoLibBlockRenderer(class_2591<?> blockEntityType) {
        GeoBlockRenderer geoBlockRenderer;
        Object v = class_310.method_1551().method_31975().field_4345.get(blockEntityType);
        return v instanceof GeoBlockRenderer ? (geoBlockRenderer = (GeoBlockRenderer)v) : null;
    }

    @Nullable
    public static GeoArmorRenderer<?, ?> getGeckoLibArmorRenderer(class_1792 item) {
        class_1799 stack = item.method_7854();
        class_10192 equippable = (class_10192)stack.method_58695(class_9334.field_54196, null);
        if (equippable == null) {
            return null;
        }
        return RenderUtil.getGeckoLibArmorRenderer(stack, equippable.comp_3174());
    }

    @Nullable
    public static GeoArmorRenderer<?, ?> getGeckoLibArmorRenderer(class_1799 stack, class_1304 slot) {
        return GeoRenderProvider.of(stack).getGeoArmorRenderer(stack, slot);
    }

    @Nullable
    public static GeoAnimatable getReplacedAnimatable(class_1299<?> entityType) {
        GeoReplacedEntityRenderer<?, ?, ?> replacedEntityRenderer = RenderUtil.getReplacedEntityRenderer(entityType);
        return replacedEntityRenderer == null ? null : (GeoAnimatable)replacedEntityRenderer.getAnimatable();
    }
}

