/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;

public class GeoGlowingTextureMeta {
    public static final MetadataSectionSerializer<GeoGlowingTextureMeta> DESERIALIZER = new MetadataSectionSerializer<GeoGlowingTextureMeta>(){

        public String m_7991_() {
            return "glowsections";
        }

        public GeoGlowingTextureMeta fromJson(JsonObject json) {
            List<Pixel> pixels = this.fromSections(GsonHelper.m_13832_((JsonObject)json, (String)"sections", null));
            if (pixels.isEmpty()) {
                throw new JsonParseException("Empty glowlayer sections file. Must have at least one glow section!");
            }
            return new GeoGlowingTextureMeta(pixels);
        }

        private List<Pixel> fromSections(@Nullable JsonArray sectionsArray) {
            if (sectionsArray == null) {
                return List.of();
            }
            ObjectArrayList pixels = new ObjectArrayList();
            for (JsonElement element : sectionsArray) {
                if (!(element instanceof JsonObject)) {
                    throw new JsonParseException("Invalid glowsections json format, expected a JsonObject, found: " + String.valueOf(element.getClass()));
                }
                JsonObject obj = (JsonObject)element;
                int x1 = GsonHelper.m_13824_((JsonObject)obj, (String)"x1", (int)GsonHelper.m_13824_((JsonObject)obj, (String)"x", (int)0));
                int y1 = GsonHelper.m_13824_((JsonObject)obj, (String)"y1", (int)GsonHelper.m_13824_((JsonObject)obj, (String)"y", (int)0));
                int x2 = GsonHelper.m_13824_((JsonObject)obj, (String)"x2", (int)(GsonHelper.m_13824_((JsonObject)obj, (String)"w", (int)0) + x1));
                int y2 = GsonHelper.m_13824_((JsonObject)obj, (String)"y2", (int)(GsonHelper.m_13824_((JsonObject)obj, (String)"h", (int)0) + y1));
                int alpha = GsonHelper.m_13824_((JsonObject)obj, (String)"alpha", (int)GsonHelper.m_13824_((JsonObject)obj, (String)"a", (int)0));
                if (x1 + y1 + x2 + y2 == 0) {
                    throw new IllegalArgumentException("Invalid glowsections section object, section must be at least one pixel in size");
                }
                for (int x = x1; x <= x2; ++x) {
                    for (int y = y1; y <= y2; ++y) {
                        pixels.add(new Pixel(x, y, alpha));
                    }
                }
            }
            return pixels;
        }
    };
    private final List<Pixel> pixels;

    public GeoGlowingTextureMeta(List<Pixel> pixels) {
        this.pixels = pixels;
    }

    public static GeoGlowingTextureMeta fromExistingImage(NativeImage glowLayer) {
        ObjectArrayList pixels = new ObjectArrayList();
        for (int x = 0; x < glowLayer.m_84982_(); ++x) {
            for (int y = 0; y < glowLayer.m_85084_(); ++y) {
                int color = glowLayer.m_84985_(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, FastColor.ABGR32.m_266503_((int)color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GeoGlowingTextureMeta((List<Pixel>)pixels);
    }

    public void createImageMask(NativeImage originalImage, NativeImage newImage) {
        for (Pixel pixel : this.pixels) {
            int color = originalImage.m_84985_(pixel.x, pixel.y);
            if (pixel.alpha > 0) {
                color = FastColor.ABGR32.m_266248_((int)pixel.alpha, (int)FastColor.ABGR32.m_266247_((int)color), (int)FastColor.ABGR32.m_266446_((int)color), (int)FastColor.ABGR32.m_266313_((int)color));
            }
            newImage.m_84988_(pixel.x, pixel.y, color);
            originalImage.m_84988_(pixel.x, pixel.y, 0);
        }
    }

    private record Pixel(int x, int y, int alpha) {
    }
}

