/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.stateless;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.stateless.StatelessAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.network.packet.blockentity.StatelessBlockEntityPlayAnimPacket;
import software.bernie.geckolib.network.packet.blockentity.StatelessBlockEntityStopAnimPacket;

public non-sealed interface StatelessGeoBlockEntity
extends StatelessAnimatable,
GeoBlockEntity {
    @Override
    default public void playAnimation(RawAnimation animation) {
        StatelessGeoBlockEntity statelessGeoBlockEntity = this;
        if (!(statelessGeoBlockEntity instanceof BlockEntity)) {
            throw new ClassCastException("Cannot use StatelessGeoBlockEntity on a non-blockentity animatable!");
        }
        BlockEntity self = (BlockEntity)statelessGeoBlockEntity;
        Level level = self.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            GeckoLibServices.NETWORK.sendToAllPlayersTrackingBlock(new StatelessBlockEntityPlayAnimPacket(self.getBlockPos(), animation), level2, self.getBlockPos());
        } else {
            this.handleClientAnimationPlay(this, 0L, animation);
        }
    }

    @Override
    default public void stopAnimation(String animation) {
        StatelessGeoBlockEntity statelessGeoBlockEntity = this;
        if (!(statelessGeoBlockEntity instanceof BlockEntity)) {
            throw new ClassCastException("Cannot use StatelessGeoBlockEntity on a non-blockentity animatable!");
        }
        BlockEntity self = (BlockEntity)statelessGeoBlockEntity;
        Level level = self.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            GeckoLibServices.NETWORK.sendToAllPlayersTrackingBlock(new StatelessBlockEntityStopAnimPacket(self.getBlockPos(), animation), level2, self.getBlockPos());
        } else {
            this.handleClientAnimationStop(this, 0L, animation);
        }
    }
}

