/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.RenderUtil;

public class CustomBoneTextureGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final String boneName;
    protected final ResourceLocation texture;

    public CustomBoneTextureGeoLayer(GeoRenderer<T, O, R> renderer, String boneName, ResourceLocation texture) {
        super(renderer);
        this.boneName = boneName;
        this.texture = texture;
    }

    @Override
    protected ResourceLocation getTextureResource(R renderState) {
        return this.texture;
    }

    protected RenderType getRenderType(R renderState, ResourceLocation texture) {
        return this.renderer.getRenderType(renderState, texture);
    }

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, boolean didRenderModel, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        if (didRenderModel) {
            model.getBone(this.boneName).ifPresent(bone -> consumer.accept((GeoBone)bone, this::renderBone));
        }
    }

    protected void renderBone(R renderState, PoseStack poseStack, GeoBone bone, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        ResourceLocation boneTexture = this.getTextureResource(renderState);
        ResourceLocation baseTexture = this.renderer.getTextureLocation(renderState);
        IntIntPair boneTextureSize = RenderUtil.getTextureDimensions(boneTexture);
        IntIntPair baseTextureSize = RenderUtil.getTextureDimensions(baseTexture);
        float widthRatio = (float)baseTextureSize.firstInt() / (float)boneTextureSize.firstInt();
        float heightRatio = (float)baseTextureSize.secondInt() / (float)boneTextureSize.secondInt();
        renderTasks.submitCustomGeometry(poseStack, this.getRenderType(renderState, boneTexture), (pose, buffer) -> {
            PoseStack poseStack2 = new PoseStack();
            poseStack2.last().set(pose);
            bone.setHidden(false);
            bone.setChildrenHidden(true);
            for (GeoCube cube : bone.getCubes()) {
                poseStack2.pushPose();
                this.renderCube(renderState, cube, poseStack2, buffer, widthRatio, heightRatio, packedLight, packedOverlay, renderColor);
                poseStack2.popPose();
            }
            bone.setHidden(false);
        });
    }

    @ApiStatus.Internal
    protected void renderCube(R renderState, GeoCube cube, PoseStack poseStack, VertexConsumer buffer, float widthRatio, float heightRatio, int packedLight, int packedOverlay, int renderColor) {
        RenderUtil.translateToPivotPoint(poseStack, cube);
        RenderUtil.rotateMatrixAroundCube(poseStack, cube);
        RenderUtil.translateAwayFromPivotPoint(poseStack, cube);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtil.fixInvertedFlatCube(cube, normal);
            this.createVerticesOfQuad(renderState, quad, poseState, normal, buffer, widthRatio, heightRatio, packedOverlay, packedLight, renderColor);
        }
    }

    @ApiStatus.Internal
    protected void createVerticesOfQuad(R renderState, GeoQuad quad, Matrix4f poseState, Vector3f normal, VertexConsumer buffer, float widthRatio, float heightRatio, int packedOverlay, int packedLight, int renderColor) {
        for (GeoVertex vertex : quad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = poseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            buffer.addVertex(vector4f.x(), vector4f.y(), vector4f.z(), renderColor, vertex.texU() * widthRatio, vertex.texV() * heightRatio, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
        }
    }

    @Override
    @ApiStatus.Internal
    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor, boolean didRenderModel) {
        if (didRenderModel) {
            bakedModel.getBone(this.boneName).ifPresent(bone -> {
                bone.setHidden(true);
                bone.setChildrenHidden(false);
            });
        }
    }
}

