/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderUtil;

public abstract class ItemArmorGeoLayer<T extends LivingEntity, O, R extends EntityRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final EquipmentLayerRenderer equipmentRenderer;
    protected final EquipmentAssetManager equipmentAssets;
    protected final Function<SkullBlock.Type, SkullModelBase> skullModels;
    protected final PlayerSkinRenderCache skinCache;

    public ItemArmorGeoLayer(GeoRenderer<T, O, R> geoRenderer, EntityRendererProvider.Context context) {
        super(geoRenderer);
        this.equipmentRenderer = context.getEquipmentRenderer();
        this.equipmentAssets = context.getEquipmentAssets();
        this.skullModels = Util.memoize(type -> SkullBlockRenderer.createModel((EntityModelSet)context.getModelSet(), (SkullBlock.Type)type));
        this.skinCache = context.getPlayerSkinRenderCache();
    }

    protected abstract List<RenderData> getRelevantBones(R var1, BakedGeoModel var2);

    @Override
    public void addRenderData(T animatable, O relatedObject, R renderState, float partialTick) {
        EnumMap<EquipmentSlot, ItemStack> equipment = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(EquipmentSlot.class));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            equipment.put(slot, animatable.getItemBySlot(slot));
        }
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        if (animatable instanceof LivingEntity) {
            T livingEntity = animatable;
            if (!((ItemStack)equipment.get(EquipmentSlot.CHEST)).isEmpty()) {
                ((GeoRenderState)renderState).addGeckolibData(DataTickets.ELYTRA_ROTATION, new Vec3((double)((LivingEntity)livingEntity).elytraAnimationState.getRotX(partialTick), (double)((LivingEntity)livingEntity).elytraAnimationState.getRotY(partialTick), (double)((LivingEntity)livingEntity).elytraAnimationState.getRotZ(partialTick)));
            }
        }
    }

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, boolean didRenderModel, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        for (RenderData renderData : this.getRelevantBones(renderState, model)) {
            model.getBone(renderData.boneName).ifPresentOrElse(bone -> this.createPerBoneRender((GeoBone)bone, renderData, consumer, renderState), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(GeoBone bone, RenderData renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer, R renderState) {
        GeoArmorRenderer.ArmorSegment armorSegment = renderData.armorSegment;
        ItemStack stack = this.getEquipmentStack(bone, armorSegment.equipmentSlot, renderState);
        if (!stack.isEmpty()) {
            consumer.accept(bone, (renderState2, poseStack, bone2, renderTasks, cameraState, packedLight, packedOverlay, renderColor) -> this.buildRenderTask(renderState2, armorSegment.equipmentSlot, armorSegment.modelPartGetter, stack, poseStack, bone2, renderTasks, cameraState, packedLight, packedOverlay, renderColor));
        }
    }

    protected void buildRenderTask(R renderState, EquipmentSlot slot, Function<HumanoidModel<?>, ModelPart> modelPartFactory, ItemStack equipmentStack, PoseStack poseStack, GeoBone bone, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        BlockItem blockItem;
        if (equipmentStack.isEmpty()) {
            return;
        }
        Object object = equipmentStack.getItem();
        if (object instanceof BlockItem && (object = (blockItem = (BlockItem)object).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)object;
            this.renderSkullAsArmor(poseStack, bone, equipmentStack, renderState, skullBlock, renderTasks, cameraState, packedLight);
        } else {
            object = RenderUtil.getGeckoLibArmorRenderer(equipmentStack, slot);
            if (object instanceof GeoArmorRenderer) {
                Object geoArmorRenderer = object;
                poseStack.pushPose();
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                geoArmorRenderer.submitRenderTasks((GeoRenderState)renderState, poseStack, renderTasks, cameraState);
                poseStack.popPose();
            } else {
                ModelPart modelPart;
                Model<?> vanillaModel = this.getArmorModelForRender(bone, slot, equipmentStack, renderState);
                if (vanillaModel instanceof HumanoidModel) {
                    HumanoidModel humanoidModel = (HumanoidModel)vanillaModel;
                    v0 = modelPartFactory.apply(humanoidModel);
                } else {
                    v0 = modelPart = vanillaModel.root();
                }
                if (!modelPart.cubes.isEmpty()) {
                    poseStack.pushPose();
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    Equippable equippable = (Equippable)equipmentStack.get(DataComponents.EQUIPPABLE);
                    if (equippable != null) {
                        equippable.assetId().ifPresent(assetId -> {
                            this.positionModelPartFromBone(poseStack, bone, modelPart);
                            this.renderVanillaArmorPiece(poseStack, renderState, bone, slot, equipmentStack, equippable, (ResourceKey<EquipmentAsset>)assetId, vanillaModel, modelPart, renderTasks, cameraState, packedLight, packedOverlay);
                        });
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    protected ItemStack getEquipmentStack(GeoBone bone, EquipmentSlot slot, R renderState) {
        return ((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).getOrDefault(slot, ItemStack.EMPTY);
    }

    protected EquipmentClientInfo.LayerType getEquipmentLayerType(R renderState, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, ResourceKey<EquipmentAsset> assetId) {
        if (slot == EquipmentSlot.LEGS) {
            return EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS;
        }
        if (slot == EquipmentSlot.CHEST && !this.equipmentAssets.get(assetId).getLayers(EquipmentClientInfo.LayerType.WINGS).isEmpty()) {
            return EquipmentClientInfo.LayerType.WINGS;
        }
        return EquipmentClientInfo.LayerType.HUMANOID;
    }

    protected void renderVanillaArmorPiece(PoseStack poseStack, R renderState, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, Equippable equippable, ResourceKey<EquipmentAsset> assetId, Model<?> model, ModelPart modelPart, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay) {
        EquipmentClientInfo.LayerType layerType = this.getEquipmentLayerType(renderState, bone, slot, armorStack, assetId);
        Model modelToRender = model;
        if (layerType == EquipmentClientInfo.LayerType.WINGS) {
            if (model instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)model;
                if (modelPart != humanoidModel.body) {
                    return;
                }
            }
            modelToRender = this.checkForElytraModel(layerType, renderState, bone, poseStack);
        }
        this.equipmentRenderer.renderLayers(layerType, assetId, modelToRender, renderState, armorStack, poseStack, renderTasks, packedLight, ((EntityRenderState)renderState).outlineColor);
    }

    protected Model checkForElytraModel(EquipmentClientInfo.LayerType layerType, R renderState, GeoBone bone, PoseStack poseStack) {
        ElytraModel model = GeckoLibClient.GENERIC_ELYTRA_MODEL.get();
        HumanoidRenderState humanoidRenderState = new HumanoidRenderState();
        Vec3 elytraRotation = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.ELYTRA_ROTATION, Vec3.ZERO);
        humanoidRenderState.isCrouching = ((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_CROUCHING);
        humanoidRenderState.elytraRotX = (float)elytraRotation.x;
        humanoidRenderState.elytraRotY = (float)elytraRotation.y;
        humanoidRenderState.elytraRotZ = (float)elytraRotation.z;
        model.setupAnim(humanoidRenderState);
        poseStack.translate(0.0f, -1.5f, 0.125f);
        return model;
    }

    @NotNull
    @ApiStatus.Internal
    protected <S extends HumanoidRenderState> Model<?> getArmorModelForRender(GeoBone bone, EquipmentSlot slot, ItemStack stack, R renderState) {
        HumanoidRenderState humanoidRenderState1;
        HumanoidRenderState humanoidRenderState = renderState instanceof HumanoidRenderState ? (humanoidRenderState1 = (HumanoidRenderState)renderState) : new HumanoidRenderState();
        EquipmentClientInfo.LayerType layerType = slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
        HumanoidModel defaultModel = (HumanoidModel)GeckoLibClient.PLAYER_ARMOR.get().get(slot);
        return GeckoLibServices.Client.ITEM_RENDERING.getArmorModelForItem(humanoidRenderState, stack, slot, layerType, defaultModel);
    }

    protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, R renderState, AbstractSkullBlock skullBlock, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight) {
        SkullBlock.Type type = skullBlock.getType();
        SkullModelBase model = this.skullModels.apply(type);
        ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        RenderType renderType = profile == null ? PlayerSkinRenderCache.DEFAULT_PLAYER_SKIN_RENDER_TYPE : this.skinCache.getOrDefault(profile).renderType();
        poseStack.pushPose();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.scale(1.1875f, 1.1875f, 1.1875f);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.submitSkull(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (SubmitNodeCollector)renderTasks, (int)packedLight, (SkullModelBase)model, (RenderType)renderType, (int)((EntityRenderState)renderState).outlineColor, null);
        poseStack.popPose();
    }

    protected void positionModelPartFromBone(PoseStack poseStack, GeoBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.getCubes().getFirst();
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.cubes.getFirst();
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        double actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        double actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        double actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        sourcePart.setPos(-(bone.getPivotX() - (bone.getPivotX() * scaleX - bone.getPivotX()) / scaleX), -(bone.getPivotY() - (bone.getPivotY() * scaleY - bone.getPivotY()) / scaleY), bone.getPivotZ() - (bone.getPivotZ() * scaleZ - bone.getPivotZ()) / scaleZ);
        sourcePart.xRot = -bone.getRotX();
        sourcePart.yRot = -bone.getRotY();
        sourcePart.zRot = bone.getRotZ();
        poseStack.scale(scaleX, scaleY, scaleZ);
    }

    public record RenderData(String boneName, GeoArmorRenderer.ArmorSegment armorSegment) {
        public static RenderData head(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.HEAD);
        }

        public static RenderData body(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.CHEST);
        }

        public static RenderData leftArm(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_ARM);
        }

        public static RenderData rightArm(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_ARM);
        }

        public static RenderData leftLeg(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_LEG);
        }

        public static RenderData rightLeg(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_LEG);
        }

        public static RenderData leftFoot(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_FOOT);
        }

        public static RenderData rightFoot(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_FOOT);
        }
    }
}

