/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animation.Animation;

public final class RawAnimation {
    public static final class_9139<ByteBuf, RawAnimation> STREAM_CODEC = class_9139.method_56434((class_9139)Stage.STREAM_CODEC.method_56433(class_9135.method_56363()), instance -> instance.animationList, RawAnimation::new);
    private final List<Stage> animationList;

    private RawAnimation() {
        this((List<Stage>)new ObjectArrayList());
    }

    private RawAnimation(List<Stage> animationList) {
        this.animationList = animationList;
    }

    public static RawAnimation begin() {
        return new RawAnimation();
    }

    public RawAnimation thenPlay(String animationName) {
        return this.then(animationName, Animation.LoopType.DEFAULT);
    }

    public RawAnimation thenLoop(String animationName) {
        return this.then(animationName, Animation.LoopType.LOOP);
    }

    public RawAnimation thenWait(int ticks) {
        this.animationList.add(new Stage("internal.wait", Animation.LoopType.PLAY_ONCE, ticks));
        return this;
    }

    public RawAnimation thenPlayAndHold(String animation) {
        return this.then(animation, Animation.LoopType.HOLD_ON_LAST_FRAME);
    }

    public RawAnimation thenPlayXTimes(String animationName, int playCount) {
        for (int i = 0; i < playCount; ++i) {
            this.then(animationName, i == playCount - 1 ? Animation.LoopType.DEFAULT : Animation.LoopType.PLAY_ONCE);
        }
        return this;
    }

    public RawAnimation then(String animationName, Animation.LoopType loopType) {
        this.animationList.add(new Stage(animationName, loopType));
        return this;
    }

    public List<Stage> getAnimationStages() {
        return this.animationList;
    }

    public static RawAnimation copyOf(RawAnimation other) {
        RawAnimation newInstance = RawAnimation.begin();
        newInstance.animationList.addAll(other.animationList);
        return newInstance;
    }

    public int getStageCount() {
        return this.animationList.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.animationList);
    }

    public String toString() {
        return "RawAnimation{" + this.animationList.stream().map(Stage::toString).collect(Collectors.joining(" -> ")) + "}";
    }

    public record Stage(String animationName, Animation.LoopType loopType, int additionalTicks) {
        public static final class_9139<ByteBuf, Stage> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, Stage::animationName, (class_9139)class_9135.field_48554.method_56432(Animation.LoopType::fromString, Animation.LoopType::getId), Stage::loopType, (class_9139)class_9135.field_48550, Stage::additionalTicks, Stage::new);
        @ApiStatus.Internal
        public static final String WAIT = "internal.wait";

        public Stage(String animationName, Animation.LoopType loopType) {
            this(animationName, loopType, 0);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }

        @Override
        public String toString() {
            return this.animationName;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.animationName, this.loopType);
        }
    }
}

