/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.event;

import java.util.function.Function;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_811;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoObjectRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public interface GeoRenderEvent<T extends GeoAnimatable, O, R extends GeoRenderState> {
    public GeoRenderer<T, O, R> getRenderer();

    public R getRenderState();

    @Nullable
    default public <D> D getRenderData(DataTicket<D> dataTicket) {
        R renderState = this.getRenderState();
        return renderState.getOrDefaultGeckolibData(dataTicket, null);
    }

    default public boolean hasData(DataTicket<?> dataTicket) {
        return this.getRenderState().hasGeckolibData(dataTicket);
    }

    default public float getPartialTick() {
        return this.getRenderState().getPartialTick();
    }

    default public int packedLight() {
        return this.getRenderState().getPackedLight();
    }

    default public Class<? extends GeoAnimatable> getAnimatableClass() {
        return this.getRenderData(DataTickets.ANIMATABLE_CLASS);
    }

    public static interface Object<T extends GeoAnimatable, E, R extends GeoRenderState>
    extends GeoRenderEvent<T, E, R> {
        @Override
        public GeoObjectRenderer<T, E, R> getRenderer();

        public static interface Post<T extends GeoAnimatable, E, R extends GeoRenderState>
        extends Object<T, E, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface Pre<T extends GeoAnimatable, E, R extends GeoRenderState>
        extends Object<T, E, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface CompileRenderState<T extends GeoAnimatable, E, R extends GeoRenderState>
        extends Object<T, E, R> {
            public T getAnimatable();

            default public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }

            @Nullable
            public E getRelatedObject();
        }

        public static interface CompileRenderLayers<T extends GeoAnimatable, E, R extends GeoRenderState>
        extends Object<T, E, R> {
            @Override
            @ApiStatus.Internal
            default public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            default public void addLayer(Function<GeoObjectRenderer<T, E, R>, GeoRenderLayer<T, E, R>> renderLayer) {
                ((GeoObjectRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }

            default public void addLayer(GeoRenderLayer<T, E, R> renderLayer) {
                ((GeoObjectRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }
        }
    }

    public static interface Item<T extends class_1792>
    extends GeoRenderEvent<T, GeoItemRenderer.RenderData, GeoRenderState> {
        public GeoItemRenderer<T> getRenderer();

        public static interface Post<T extends class_1792>
        extends Item<T> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface Pre<T extends class_1792>
        extends Item<T> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface CompileRenderState<T extends class_1792>
        extends Item<T> {
            public T getAnimatable();

            public GeoItemRenderer.RenderData getRenderData();

            default public class_1799 getItemStack() {
                return this.getRenderData().itemStack();
            }

            default public class_811 getRenderPerspective() {
                return this.getRenderData().renderPerspective();
            }

            default public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                this.getRenderState().addGeckolibData(dataTicket, data);
            }
        }

        public static interface CompileRenderLayers<T extends class_1792>
        extends Item<T> {
            @Override
            @ApiStatus.Internal
            default public GeoRenderState getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            default public void addLayer(Function<GeoItemRenderer<T>, GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState>> renderLayer) {
                ((GeoItemRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }

            default public void addLayer(GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState> renderLayer) {
                ((GeoItemRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }
        }
    }

    public static interface ReplacedEntity<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
    extends GeoRenderEvent<T, E, R> {
        @Override
        public GeoReplacedEntityRenderer<T, E, R> getRenderer();

        public static interface Post<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface Pre<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface CompileRenderState<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            public GeoAnimatable getAnimatable();

            public class_1297 getReplacedEntity();

            default public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)((class_10017)this.getRenderState())).addGeckolibData(dataTicket, data);
            }
        }

        public static interface CompileRenderLayers<T extends GeoAnimatable, E extends class_1297, R extends class_10017>
        extends ReplacedEntity<T, E, R> {
            @Override
            @ApiStatus.Internal
            default public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            default public void addLayer(Function<GeoReplacedEntityRenderer<T, E, R>, GeoRenderLayer<T, E, R>> renderLayer) {
                ((GeoReplacedEntityRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }

            default public void addLayer(GeoRenderLayer<T, E, R> renderLayer) {
                ((GeoReplacedEntityRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }
        }
    }

    public static interface Entity<T extends class_1297, R extends class_10017>
    extends GeoRenderEvent<T, Void, R> {
        public GeoEntityRenderer<T, R> getRenderer();

        public static interface Post<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface Pre<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface CompileRenderState<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            public T getAnimatable();

            default public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)((class_10017)this.getRenderState())).addGeckolibData(dataTicket, data);
            }
        }

        public static interface CompileRenderLayers<T extends class_1297, R extends class_10017>
        extends Entity<T, R> {
            @Override
            @ApiStatus.Internal
            default public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            default public void addLayer(Function<GeoEntityRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
                ((GeoEntityRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }

            default public void addLayer(GeoRenderLayer<T, Void, R> renderLayer) {
                ((GeoEntityRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }
        }
    }

    public static interface Armor<T extends class_1792, R extends class_10055>
    extends GeoRenderEvent<T, GeoArmorRenderer.RenderData, R> {
        public GeoArmorRenderer<T, R> getRenderer();

        public static interface Post<T extends class_1792, R extends class_10055>
        extends Armor<T, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface Pre<T extends class_1792, R extends class_10055>
        extends Armor<T, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface CompileRenderState<T extends class_1792, R extends class_10055>
        extends Armor<T, R> {
            public T getAnimatable();

            public GeoArmorRenderer.RenderData getRenderData();

            default public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)((class_10055)this.getRenderState())).addGeckolibData(dataTicket, data);
            }
        }

        public static interface CompileRenderLayers<T extends class_1792, R extends class_10055>
        extends Armor<T, R> {
            @Override
            @ApiStatus.Internal
            default public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            default public void addLayer(Function<GeoArmorRenderer<T, R>, GeoRenderLayer<T, GeoArmorRenderer.RenderData, R>> renderLayer) {
                ((GeoArmorRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }

            default public void addLayer(GeoRenderLayer<T, GeoArmorRenderer.RenderData, R> renderLayer) {
                ((GeoArmorRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }
        }
    }

    public static interface Block<T extends class_2586, R extends class_11954>
    extends GeoRenderEvent<T, Void, R> {
        public GeoBlockRenderer<T, R> getRenderer();

        public static interface Post<T extends class_2586, R extends class_11954>
        extends Block<T, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface Pre<T extends class_2586, R extends class_11954>
        extends Block<T, R> {
            public class_4587 getPoseStack();

            public BakedGeoModel getModel();

            public class_11659 getRenderTasks();

            public class_12075 getCameraState();
        }

        public static interface CompileRenderState<T extends class_2586, R extends class_11954>
        extends Block<T, R> {
            public T getAnimatable();

            default public <D> void addData(DataTicket<D> dataTicket, @Nullable D data) {
                ((GeoRenderState)((class_11954)this.getRenderState())).addGeckolibData(dataTicket, data);
            }
        }

        public static interface CompileRenderLayers<T extends class_2586, R extends class_11954>
        extends Block<T, R> {
            @Override
            @ApiStatus.Internal
            default public R getRenderState() {
                throw new IllegalAccessError("Attempted to access render state of a CompileRenderLayers event. There is no render state for this event.");
            }

            default public void addLayer(Function<GeoBlockRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
                ((GeoBlockRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }

            default public void addLayer(GeoRenderLayer<T, Void, R> renderLayer) {
                ((GeoBlockRenderer)this.getRenderer()).withRenderLayer(renderLayer);
            }
        }
    }
}

