/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_10017;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationProcessor;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.cache.GeckoLibResources;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class GeoModel<T extends GeoAnimatable> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animationTicks;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;

    public abstract class_2960 getModelResource(GeoRenderState var1);

    public abstract class_2960 getTextureResource(GeoRenderState var1);

    public abstract class_2960 getAnimationResource(T var1);

    public class_2960[] getAnimationResourceFallbacks(T animatable) {
        return new class_2960[0];
    }

    @Nullable
    public class_1921 getRenderType(GeoRenderState renderState, class_2960 texture) {
        return class_1921.method_23578((class_2960)texture);
    }

    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable(this.getAnimationProcessor().getBone(name));
    }

    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, GeoRenderState renderState) {
    }

    public void setCustomAnimations(AnimationState<T> animationState) {
    }

    public void applyMolangQueries(T animatable) {
    }

    public BakedGeoModel getBakedModel(class_2960 location) {
        BakedGeoModel model = GeckoLibResources.getBakedModels().get(location);
        if (model == null) {
            class_2960 strippedPath = GeckoLibResources.stripPrefixAndSuffix(location);
            if (!location.equals((Object)strippedPath)) {
                GeckoLibConstants.LOGGER.debug("Unnecessary prefix or suffix found in model resource path: {} ({}). Remove this from your getModelResource", (Object)location.method_12832(), (Object)location.method_12832().replace(strippedPath.method_12832(), ""));
                location = strippedPath;
                model = GeckoLibResources.getBakedModels().get(location);
            }
            if (model == null) {
                throw new IllegalArgumentException("Unable to find model file: " + String.valueOf(location));
            }
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    @Nullable
    public Animation getAnimation(T animatable, String name) throws RuntimeException {
        BakedAnimations bakedAnimations;
        class_2960 location = this.getAnimationResource(animatable);
        class_2960[] fallbackLocations = this.getAnimationResourceFallbacks(animatable);
        Map<class_2960, BakedAnimations> animations = GeckoLibResources.getBakedAnimations();
        int fallbackIndex = 0;
        while (true) {
            Animation animation;
            class_2960 strippedPath;
            if ((bakedAnimations = animations.get(location)) == null && !(strippedPath = GeckoLibResources.stripPrefixAndSuffix(location)).equals((Object)location)) {
                GeckoLibConstants.LOGGER.debug("Unnecessary prefix or suffix found in animations resource path: {} ({}). Remove this from your getAnimationResource", (Object)location.method_12832(), (Object)location.method_12832().replace(strippedPath.method_12832(), ""));
                bakedAnimations = animations.get(strippedPath);
            }
            if (bakedAnimations != null && (animation = bakedAnimations.getAnimation(name)) != null) {
                return animation;
            }
            if (fallbackIndex >= fallbackLocations.length) break;
            location = fallbackLocations[fallbackIndex++];
        }
        if (bakedAnimations == null) {
            throw new IllegalArgumentException("Unable to find animation file '" + String.valueOf(location) + "' for animatable '" + animatable.getClass().getName() + "'");
        }
        GeckoLibConstants.LOGGER.error("Unable to find animation: '{}' in animation file '{}' for animatable '{}'", (Object)name, (Object)location, (Object)animatable.getClass().getName());
        return null;
    }

    @ApiStatus.Internal
    public void prepareForRenderPass(T animatable, GeoRenderState renderState, float partialTick) {
        boolean isReRender;
        double animatableRenderTime;
        class_10017 state;
        class_310 mc = class_310.method_1551();
        long instanceId = renderState.getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID);
        AnimatableManager animatableManager = renderState.getGeckolibData(DataTickets.ANIMATABLE_MANAGER);
        class_10017 entityRenderState = renderState instanceof class_10017 ? (state = (class_10017)renderState) : null;
        double d = animatableRenderTime = entityRenderState != null ? (double)entityRenderState.field_53328 : renderState.getGeckolibData(DataTickets.TICK);
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(animatableRenderTime);
        }
        double currentFrameTime = entityRenderState != null ? animatableRenderTime : animatableRenderTime - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (!mc.method_1493() || animatable.shouldPlayAnimsWhileGamePaused()) {
            animatableManager.updatedAt(currentFrameTime);
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animationTicks += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        renderState.addGeckolibData(DataTickets.ANIMATION_TICKS, this.animationTicks);
        this.addAdditionalStateData(animatable, renderState);
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        this.lastRenderedInstance = instanceId;
        this.applyMolangQueries(animatable);
        this.getAnimationProcessor().prepareForRenderPass(animatable, animatableManager, renderState, this.animationTicks, this);
    }

    @ApiStatus.Internal
    public void handleAnimations(AnimationState<T> animationState) {
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animationState);
        }
        this.setCustomAnimations(animationState);
    }
}

