/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoBlockRenderer<T extends class_2586, R extends class_11954>
implements GeoRenderer<T, Void, R>,
class_827<T, R> {
    protected final GeoRenderLayersContainer<T, Void, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoBlockRenderer(class_2591<? extends T> blockEntityType) {
        this(new DefaultedBlockGeoModel(class_7923.field_41181.method_10221(blockEntityType)));
    }

    public GeoBlockRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoBlockRenderer<T, R> withRenderLayer(Function<? super GeoBlockRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoBlockRenderer<T, R> withRenderLayer(GeoRenderLayer<T, Void, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoBlockRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoBlockRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, Void relatedObject) {
        return animatable.method_11016().hashCode();
    }

    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCKSTATE, animatable.method_11010());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.POSITION, class_243.method_24953((class_2382)animatable.method_11016()));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCK_FACING, this.getFacing(animatable));
        return renderState;
    }

    @Override
    public void preRender(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        poseStack.method_22904(0.5, 0.0, 0.5);
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, cameraState);
    }

    @Override
    public void adjustRenderPose(R renderState, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        this.rotateBlock(((GeoRenderState)renderState).getGeckolibData(DataTickets.BLOCK_FACING), poseStack);
    }

    @ApiStatus.Internal
    public void method_3569(R renderState, class_4587 poseStack, class_11659 renderTasks, class_12075 cameraRenderState) {
        this.submitRenderTasks(renderState, poseStack, renderTasks, cameraRenderState);
    }

    @Override
    public void renderBone(R renderState, class_4587 poseStack, GeoBone bone, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.OBJECT_RENDER_POSE));
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            class_2338 pos = ((class_11954)renderState).field_62673;
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.MODEL_RENDER_POSE)));
            bone.setLocalSpaceMatrix(localMatrix);
            bone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260())));
        }
        GeoRenderer.super.renderBone(renderState, poseStack, bone, buffer, cameraState, packedLight, packedOverlay, renderColor);
    }

    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        switch (facing) {
            case field_11035: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees(90.0f));
                break;
            }
            case field_11036: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case field_11033: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40713.rotationDegrees(90.0f));
                break;
            }
        }
    }

    protected class_2350 getFacing(T blockEntity) {
        class_2680 blockState = blockEntity.method_11010();
        if (blockState.method_28498((class_2769)class_2383.field_11177)) {
            return (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        }
        if (blockState.method_28498((class_2769)class_2318.field_10927)) {
            return (class_2350)blockState.method_11654((class_2769)class_2318.field_10927);
        }
        return class_2350.field_11043;
    }

    @ApiStatus.Internal
    public R method_74335() {
        return (R)new class_11954();
    }

    public void method_74331(T blockEntity, R renderState, float partialTick, class_243 cameraPos, @Nullable class_11683.class_11792 damageOverlayState) {
        super.method_74331(blockEntity, renderState, partialTick, cameraPos, damageOverlayState);
        this.fillRenderState(blockEntity, null, renderState, partialTick);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        return GeckoLibServices.Client.EVENTS.fireBlockPreRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    public void firePostRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        GeckoLibServices.Client.EVENTS.fireBlockPostRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public final R createRenderState(T animatable, Void relatedObject) {
        return (R)new class_11954();
    }
}

