/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10444;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_11785;
import net.minecraft.class_12075;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5599;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_824;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRenderTasks;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoItemRenderer<T extends class_1792>
implements GeoRenderer<T, RenderData, GeoRenderState> {
    protected final GeoRenderLayersContainer<T, RenderData, GeoRenderState> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;

    public <I extends T> GeoItemRenderer(I item) {
        this(new DefaultedItemGeoModel(class_7923.field_41178.method_10221(item)));
    }

    public GeoItemRenderer(GeoModel<T> model) {
        this(class_310.method_1551().method_31975(), class_310.method_1551().method_31974(), model);
    }

    public GeoItemRenderer(class_824 dispatcher, class_5599 modelSet, GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    public GeoItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public List<GeoRenderLayer<T, RenderData, GeoRenderState>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoItemRenderer<T> withRenderLayer(Function<? super GeoItemRenderer<T>, GeoRenderLayer<T, RenderData, GeoRenderState>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoItemRenderer<T> withRenderLayer(GeoRenderLayer<T, RenderData, GeoRenderState> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoItemRenderer<T> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoItemRenderer<T> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, RenderData renderData) {
        return GeoItem.getId(renderData.itemStack);
    }

    @Override
    @ApiStatus.Internal
    public GeoRenderState captureDefaultRenderState(T animatable, RenderData renderData, GeoRenderState renderState, float partialTick) {
        long instanceId = this.getInstanceId(animatable, renderData);
        class_1799 stack = renderData.itemStack;
        renderState.addGeckolibData(DataTickets.ITEM, animatable);
        renderState.addGeckolibData(DataTickets.TICK, ((GeoAnimatable)animatable).getTick(animatable));
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, instanceId);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, ((GeoAnimatable)animatable).getAnimatableInstanceCache().getManagerForId(instanceId));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, this.getRenderColor(animatable, renderData, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, false);
        renderState.addGeckolibData(DataTickets.BONE_RESET_TIME, ((GeoAnimatable)animatable).getBoneResetTime());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, animatable.getClass());
        renderState.addGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE, renderData.renderPerspective);
        renderState.addGeckolibData(DataTickets.IS_ENCHANTED, stack.method_7942());
        renderState.addGeckolibData(DataTickets.IS_STACKABLE, stack.method_7946());
        renderState.addGeckolibData(DataTickets.MAX_USE_DURATION, stack.method_7935((class_1309)ClientUtil.getClientPlayer()));
        renderState.addGeckolibData(DataTickets.MAX_DURABILITY, stack.method_7936());
        renderState.addGeckolibData(DataTickets.REMAINING_DURABILITY, stack.method_7963() ? stack.method_7936() - stack.method_7919() : 1);
        renderState.addGeckolibData(DataTickets.PER_BONE_TASKS, PerBoneRenderTasks.create());
        return renderState;
    }

    @Override
    public void preRender(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        ((GeoAnimatable)renderState.getGeckolibData(DataTickets.ITEM)).getAnimatableInstanceCache().getManagerForId(renderState.getGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID)).setAnimatableData(DataTickets.ITEM_RENDER_PERSPECTIVE, renderState.getGeckolibData(DataTickets.ITEM_RENDER_PERSPECTIVE));
    }

    @Override
    public void adjustRenderPose(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        poseStack.method_46416(0.5f, 0.51f, 0.5f);
    }

    @Override
    public void scaleModelForRender(GeoRenderState renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, cameraState);
    }

    public void submit(GeoRenderState renderState, class_4587 poseStack, class_11659 renderTasks, int outlineColor) {
        renderState.addGeckolibData(DataTickets.GLOW_COLOUR, outlineColor);
        this.submitRenderTasks(renderState, poseStack, renderTasks, class_310.method_1551().field_1773.method_72912().field_63082);
    }

    @Override
    public void buildRenderTask(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_11785 renderTasks, class_12075 cameraState, @Nullable class_1921 renderType, int packedLight, int packedOverlay, int renderColor) {
        if (renderType == null) {
            return;
        }
        GeoRenderer.super.buildRenderTask(renderState, poseStack, model, renderTasks, cameraState, renderType, packedLight, packedOverlay, renderColor);
    }

    @Override
    public void renderBone(GeoRenderState renderState, class_4587 poseStack, GeoBone bone, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, renderState.getGeckolibData(DataTickets.OBJECT_RENDER_POSE)));
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, renderState.getGeckolibData(DataTickets.MODEL_RENDER_POSE)));
        }
        GeoRenderer.super.renderBone(renderState, poseStack, bone, buffer, cameraState, packedLight, packedOverlay, renderColor);
    }

    @Override
    public GeoRenderState createRenderState(T animatable, RenderData relatedObject) {
        return new GeoRenderState.Impl();
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60028);
        } else {
            class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, RenderData renderData, GeoRenderState renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileItemRenderState(this, renderState, animatable, renderData);
    }

    @Override
    public boolean firePreRenderEvent(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        return GeckoLibServices.Client.EVENTS.fireItemPreRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    public void firePostRenderEvent(GeoRenderState renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        GeckoLibServices.Client.EVENTS.fireItemPostRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    public record RenderData(class_1799 itemStack, class_10444 vanillaRenderState, class_811 renderPerspective, @Nullable class_638 level, @Nullable class_11566 itemOwner) {
    }
}

