/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import java.util.List;
import java.util.function.Function;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoObjectRenderer<T extends GeoAnimatable, E, R extends GeoRenderState>
implements GeoRenderer<T, E, R> {
    protected final GeoRenderLayersContainer<T, E, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoObjectRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, E, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoObjectRenderer<T, E, R> withRenderLayer(Function<? super GeoObjectRenderer<T, E, R>, GeoRenderLayer<T, E, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoObjectRenderer<T, E, R> withRenderLayer(GeoRenderLayer<T, E, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoObjectRenderer<T, E, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoObjectRenderer<T, E, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, cameraState);
    }

    @Override
    public void adjustRenderPose(R renderState, class_4587 poseStack, BakedGeoModel model, class_12075 cameraState) {
        poseStack.method_46416(0.5f, 0.51f, 0.5f);
    }

    public void submit(class_4587 poseStack, T animatable, E relatedObject, class_11659 renderTasks, class_12075 cameraState, int packedLight, float partialTick) {
        R renderState = this.fillRenderState(animatable, relatedObject, this.createRenderState(animatable, (E)null), partialTick);
        renderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        this.submitRenderTasks(renderState, poseStack, renderTasks, cameraState);
    }

    @Override
    public void renderBone(R renderState, class_4587 poseStack, GeoBone bone, class_4588 buffer, class_12075 cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, renderState.getGeckolibData(DataTickets.OBJECT_RENDER_POSE)));
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, renderState.getGeckolibData(DataTickets.MODEL_RENDER_POSE)));
        }
        GeoRenderer.super.renderBone(renderState, poseStack, bone, buffer, cameraState, packedLight, packedOverlay, renderColor);
    }

    @Override
    public R createRenderState(T animatable, E relatedObject) {
        return (R)new GeoRenderState.Impl();
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileObjectRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, @Nullable E relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileObjectRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        return GeckoLibServices.Client.EVENTS.fireObjectPreRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    public void firePostRenderEvent(R renderState, class_4587 poseStack, BakedGeoModel model, class_11659 renderTasks, class_12075 cameraState) {
        GeckoLibServices.Client.EVENTS.fireObjectPostRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }
}

